package cn.schoolwow.quick.starter.ams.listener.table.sys;

import cn.schoolwow.ams.domain.listener.table.AMSTableListener;
import cn.schoolwow.ams.domain.listener.table.ListTable;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSTableListenerAware;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.PageVo;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class TaskLogTableListener implements AMSTableListenerAware {
    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSTableListener> getAMSTableListenerList() {
        return Arrays.asList(new AMSTableListener()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@task_log")
                .listTable(new ListTable() {
                    @Override
                    public void beforeExecuteCondition(Condition condition, JSONObject amsListCondition) throws Exception {
                        Integer logOption = amsListCondition.getInteger("logOption");
                        if(null!=logOption){
                            switch (logOption){
                                case 1:{
                                    condition.addNullQuery("broken_reason")
                                            .addNullQuery("exception");
                                }break;
                                case 2:{
                                    condition.addNotNullQuery("exception");
                                }break;
                                case 3:{
                                    condition.addNotNullQuery("broken_reason");
                                }break;
                            }
                        }
                    }

                    @Override
                    public void afterExecuteCondition(Condition condition, JSONObject amsListCondition, PageVo pageVo) throws Exception {

                    }
                })
        );
    }
}
