package cn.schoolwow.quick.starter.config;

import cn.schoolwow.quick.starter.config.flow.StarterFlowConfigMapListener;
import cn.schoolwow.quick.starter.config.flow.StarterMallFlowMappingHandler;
import cn.schoolwow.quick.starter.config.flow.StarterMallTryCatchFinallyHandler;
import cn.schoolwow.quickflow.QuickFlow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class QuickFlowConfig {
    @Bean
    @Autowired
    public QuickFlow quickFlow(ApplicationContext applicationContext) {
        QuickFlow quickFlow = QuickFlow.newInstance()
                .executeGlobalSingleFlow(true)
                .executeGlobalBeforeAfter(true)
                .tryCatchFinallyHandler(applicationContext.getBean(StarterMallTryCatchFinallyHandler.class))
                .flowNameInstanceMappingHandler(applicationContext.getBean(StarterMallFlowMappingHandler.class))
                .flowConfigRequestDataHandler(applicationContext.getBean(StarterFlowConfigMapListener.class));
        return quickFlow;
    }

}
