package cn.schoolwow.quick.starter.config.flow;

import cn.schoolwow.quick.starter.entity.sys.ProjectFlowConfig;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickflow.listener.FlowConfigRequestDataHandler;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class StarterFlowConfigMapListener implements FlowConfigRequestDataHandler {
    @Resource
    private DAO starterDAO;

    @Override
    public Map<String, JSONObject> loadFlowConfigRequestDataMap() {
        List<ProjectFlowConfig> projectFlowConfigList = starterDAO.query(ProjectFlowConfig.class).execute().getList();
        Map<String,JSONObject> flowConfigMap = new HashMap<>();
        for(ProjectFlowConfig projectFlowConfig:projectFlowConfigList){
            flowConfigMap.put(projectFlowConfig.getName(), projectFlowConfig.getRequestData());
        }
        return flowConfigMap;
    }

    @Override
    public void saveFlowConfigRequestData(String flowName, JSONObject requestData) {
        ProjectFlowConfig projectFlowConfig = new ProjectFlowConfig();
        projectFlowConfig.setName(flowName);
        projectFlowConfig.setRequestData(requestData);

        if(!starterDAO.exist(projectFlowConfig)){
            starterDAO.insert(projectFlowConfig);
        }
        JSONObject databaseRequestData = starterDAO.query(ProjectFlowConfig.class)
                .addQuery("name", projectFlowConfig.getName())
                .addColumn("requestData")
                .setColumnTypeMap("requestData", JSONObject.class)
                .execute()
                .getSingleColumn(JSONObject.class);
        putIncrementConfig(requestData, databaseRequestData);
        starterDAO.updateType(UpdateType.UpdateByUniqueKey).update(projectFlowConfig);
    }

    private void putIncrementConfig(JSONObject source, JSONObject target){
        if(null==target){
            return;
        }
        Set<String> keySet = source.keySet();
        for(String key:keySet){
            if(source.get(key) instanceof JSONObject){
                putIncrementConfig(source.getJSONObject(key), target.getJSONObject(key));
            }else if(target.containsKey(key)){
                source.put(key, target.get(key));
            }
        }
    }
}
