package cn.schoolwow.quick.starter.config.flow;

import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class StarterMallTryCatchFinallyHandler implements TryCatchFinallyHandler {
    private Logger logger = LoggerFactory.getLogger(StarterMallTryCatchFinallyHandler.class);

    @Resource
    private DAO starterDAO;

    @Override
    public void handleTry(FlowContext flowContext) {
        flowContext.putTemporaryData("__startTime", System.currentTimeMillis());
        CommonUtil.flowIdThreadLocal.set(flowContext.getId());
    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {

    }

    @Override
    public void handleFinally(FlowContext flowContext) {
        starterDAO.insertLog();

        Boolean recordLog = (Boolean) flowContext.getData("recordLog");
        if(null!=recordLog&&!recordLog){
            return;
        }

        if(flowContext.getFlowExecutorRootConfig().flowConfig.debug){
            logger.info("\r\n"+flowContext.getFlowTrace());
        }

        //记录流程日志
        FlowLog flowLog = CommonUtil.flowContext2FlowLog(flowContext);
        starterDAO.insert(flowLog);
    }

    @Override
    public String name() {
        return "全局流程事件处理";
    }
}
