package cn.schoolwow.quick.starter.entity.log;

import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.TableField;
import com.alibaba.fastjson.JSONObject;

import java.time.LocalDateTime;

@Comment("流程日志")
public class FlowLog {
    @Id
    private long id;

    @Comment("流程id")
    private Long flowId;

    @Comment("流程名称")
    private String name;

    @Comment("请求数据")
    @ColumnType("longtext")
    private String requestData;

    @Comment("上下文数据")
    private JSONObject contextData;

    @Comment("流程列表")
    @ColumnType("text")
    private String flowNameList;

    @Comment("执行路径")
    @ColumnType("mediumtext")
    private String flowTrace;

    @Comment("中断原因")
    private String brokenReason;

    @Comment("异常名称")
    @ColumnType("text")
    private String exceptionMessage;

    @Comment("流程异常信息")
    @ColumnType("mediumtext")
    private String exception;

    @Comment("耗时-毫秒")
    private Long consumeTime;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRequestData() {
        return requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public JSONObject getContextData() {
        return contextData;
    }

    public void setContextData(JSONObject contextData) {
        this.contextData = contextData;
    }

    public String getFlowNameList() {
        return flowNameList;
    }

    public void setFlowNameList(String flowNameList) {
        this.flowNameList = flowNameList;
    }

    public String getFlowTrace() {
        return flowTrace;
    }

    public void setFlowTrace(String flowTrace) {
        this.flowTrace = flowTrace;
    }

    public String getBrokenReason() {
        return brokenReason;
    }

    public void setBrokenReason(String brokenReason) {
        this.brokenReason = brokenReason;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getException() {
        return exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public Long getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(Long consumeTime) {
        this.consumeTime = consumeTime;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
