package cn.schoolwow.quick.starter.entity.log;

import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.TableField;
import com.alibaba.fastjson.JSONObject;

import java.sql.Timestamp;
import java.time.LocalDateTime;

@Comment("定时任务日志")
public class TaskLog {
    @Id
    private long id;

    @Comment("启动时间")
    private Timestamp startTime;

    @Comment("结束时间")
    private Timestamp endTime;

    @Comment("耗时-毫秒")
    private Long consumeTime;

    @Comment("定时任务名称")
    private String name;

    @Comment("流程id")
    private Long flowId;

    @Comment("流程列表")
    @ColumnType("text")
    private String flowNameList;

    @Comment("流程日志")
    @ColumnType("mediumtext")
    private String flowTrace;

    @Comment("请求数据")
    private JSONObject requestData;

    @Comment("上下文数据")
    private JSONObject contextData;

    @Comment("异常信息")
    @ColumnType("mediumtext")
    private String exception;

    @Comment("中断原因")
    private String brokenReason;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Long getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(Long consumeTime) {
        this.consumeTime = consumeTime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getFlowNameList() {
        return flowNameList;
    }

    public void setFlowNameList(String flowNameList) {
        this.flowNameList = flowNameList;
    }

    public String getFlowTrace() {
        return flowTrace;
    }

    public void setFlowTrace(String flowTrace) {
        this.flowTrace = flowTrace;
    }

    public JSONObject getRequestData() {
        return requestData;
    }

    public void setRequestData(JSONObject requestData) {
        this.requestData = requestData;
    }

    public JSONObject getContextData() {
        return contextData;
    }

    public void setContextData(JSONObject contextData) {
        this.contextData = contextData;
    }

    public String getException() {
        return exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getBrokenReason() {
        return brokenReason;
    }

    public void setBrokenReason(String brokenReason) {
        this.brokenReason = brokenReason;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
