package cn.schoolwow.quick.starter.entity.sys;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.TableField;
import cn.schoolwow.quickdao.annotation.UniqueField;
import com.alibaba.fastjson.JSONObject;

import java.time.LocalDateTime;

@Comment("流程记录")
@UniqueField(columns = {"categoryName","name"})
public class FlowRecord {
    @Id
    private long id;

    @Comment("流程分类")
    private String categoryName;

    @Comment("流程名称")
    private String name;

    @Comment("流程列表")
    private String flowNameList;

    @Comment("请求数据")
    private JSONObject requestData;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFlowNameList() {
        return flowNameList;
    }

    public void setFlowNameList(String flowNameList) {
        this.flowNameList = flowNameList;
    }

    public JSONObject getRequestData() {
        return requestData;
    }

    public void setRequestData(JSONObject requestData) {
        this.requestData = requestData;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
