package cn.schoolwow.quick.starter.entity.sys;

import cn.schoolwow.quickdao.annotation.*;
import com.alibaba.fastjson.JSONObject;

import java.time.LocalDateTime;

@Comment("项目流程配置")
@UniqueField(columns = "name")
public class ProjectFlowConfig {
    @Id
    private long id;

    @Comment("流程名称")
    @Constraint(notNull = true)
    @Index(indexType = IndexType.UNIQUE)
    private String name;

    @Comment("配置数据")
    private JSONObject requestData;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JSONObject getRequestData() {
        return requestData;
    }

    public void setRequestData(JSONObject requestData) {
        this.requestData = requestData;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
