package cn.schoolwow.quick.starter.flow.ams;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ExecuteFlow implements BusinessFlow {
    @Resource
    private QuickFlow quickFlow;

    @Autowired(required = false)
    private List<CompositeBusinessFlow> compositeBusinessFlowList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject data = (JSONObject) flowContext.checkData("data");

        JSONArray flowList = data.getJSONArray("list");
        for(int i=0;i<flowList.size();i++){
            JSONObject flow = flowList.getJSONObject(i);

            String name = flow.getString("name");
            JSONObject requestData = flow.getJSONObject("requestData");

            //首先匹配复合流程
            for(CompositeBusinessFlow compositeBusinessFlow:compositeBusinessFlowList){
                String compositeBusinessName = compositeBusinessFlow.name();
                if(name.equalsIgnoreCase(compositeBusinessName)){
                    QuickFlowExecutor quickFlowExecutor = quickFlow.startFlow(compositeBusinessFlow);
                    if(null!=requestData){
                        quickFlowExecutor.putTemporaryData(requestData);
                    }
                    quickFlowExecutor.execute();
                    return;
                }
            }

            Validate.isTrue(flow.containsKey("flowNameList"), "流程列表不能为空");

            FlowExecutorOption flowExecutorOption = new FlowExecutorOption();
            flowExecutorOption.name = name;
            flowExecutorOption.flowNameList = Arrays.asList(flow.getString("flowNameList").split(",", -1));
            if(null!=requestData){
                flowExecutorOption.requestData.putAll(requestData);
            }
            quickFlow.startFlow(flowExecutorOption).execute();
        }
    }

    @Override
    public String name() {
        return "执行流程";
    }
}
