package cn.schoolwow.quick.starter.flow.composite;

import cn.schoolwow.quick.starter.flow.sys.DatabaseLogCleanFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class DatabaseLogCleanCompositeBusiness implements CompositeBusinessFlow {
    @Resource
    private ApplicationContext applicationContext;

    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(applicationContext.getBean(DatabaseLogCleanFlow.class));
    }

    @Override
    public String name() {
        return "定时清理数据库日志";
    }

}
