package cn.schoolwow.quick.starter.flow.controller.auth;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.HasFlowConfig;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Service
public class HttpBasicAuthFlow implements BusinessFlow, HasFlowConfig {
    @Value("${spring.profiles.active}")
    private String activeProfile;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String authorization = (String) flowContext.getData("authorization");
        String authEnvironment = (String) flowContext.getData("认证环境");
        String authUserName = (String) flowContext.getData("认证用户名");
        String authPassword = (String) flowContext.getData("认证密码");

        if(StringUtils.isBlank(authEnvironment)){
            flowContext.putTemporaryData("pass", true);
            return;
        }

        if(!authEnvironment.equalsIgnoreCase(activeProfile)){
            flowContext.putTemporaryData("pass", true);
            return;
        }

        if(StringUtils.isBlank(authUserName)&&StringUtils.isBlank(authPassword)){
            flowContext.putTemporaryData("pass", true);
            return;
        }

        flowContext.putTemporaryData("pass", false);
        if (StringUtils.isNoneBlank(authorization)) {
            String credentials = authorization.substring("Basic ".length());
            String decodedCredentials = new String(Base64.getDecoder().decode(credentials.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            String username = decodedCredentials.substring(0, decodedCredentials.indexOf(":"));
            String password = decodedCredentials.substring(decodedCredentials.indexOf(":") + 1);
            if (authUserName.equals(username) && authPassword.equals(password)) {
                flowContext.putTemporaryData("pass", true);
            }
        }
    }

    @Override
    public String name() {
        return "Http-Basic认证";
    }

    @Override
    public void setRequestData(JSONObject requestData) {
        requestData.put("认证环境", "");
        requestData.put("认证用户名", "");
        requestData.put("认证密码", "");
    }
}
