package cn.schoolwow.quick.starter.flow.sys;

import cn.schoolwow.data.thread.QuickDataThread;
import cn.schoolwow.data.thread.work.single.SingleDataThreadHandler;
import cn.schoolwow.data.thread.work.single.SingleDataThreadWork;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.HasFlowConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

@Service
public class DatabaseLogCleanFlow implements BusinessFlow, HasFlowConfig {
    @Resource
    private DAO starterDAO;

    @Resource
    private QuickDataThread quickDataThread;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray tableNameArray = (JSONArray) flowContext.checkData("清理数据库表名");
        List<String> tableNameList = tableNameArray.toJavaList(String.class);
        Integer remainDays = (Integer) flowContext.checkData("保存日志天数");
        Validate.isTrue(remainDays>3, "保存日志天数至少大于3");

        LocalDate time = LocalDate.now().minusDays(remainDays);

        quickDataThread.executeSingleDataThreadWork(new SingleDataThreadWork("清理数据库表")
                .list(tableNameList)
                .singleDataThreadHandler(new SingleDataThreadHandler<String>() {
                    @Override
                    public void handleSingleList(String tableName) throws Exception {
                        int effect = starterDAO.query(tableName)
                                .addQuery("created_at", "<", time)
                                .execute()
                                .delete();
                        flowContext.putData(tableName+"DeleteEffect", effect);
                    }
                })
        );
    }

    @Override
    public String name() {
        return "数据库日志定时清理";
    }

    @Override
    public void setRequestData(JSONObject requestData) {
        requestData.put("清理数据库表名",
                Arrays.asList(
                        "log@flow_log",
                        "log@http_request_log",
                        "log@task_log"
                )
        );
        requestData.put("保存日志天数", 14);
    }
}
