package cn.schoolwow.quick.starter.flow.task;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quick.starter.entity.log.TaskLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.sql.Timestamp;

@Service
public class TaskLogTryCatchFinallyHandler implements TryCatchFinallyHandler {
    @Value("${spring.profiles.active}")
    private String activeProfile;

    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Resource
    private QuickFlow quickFlow;

    @PostConstruct
    public void postConstruct(){
        JSONObject requestData = new JSONObject();
        requestData.put("是否启用定时任务", true);
        quickFlow.saveFlowConfigRequestData("定时任务全局配置", requestData);
    }

    @Override
    public void handleTry(FlowContext flowContext) {
        TaskLog taskLog = starterDAO.log(TaskLog.class);
        taskLog.setFlowId(flowContext.getId());
        taskLog.setStartTime(new Timestamp(System.currentTimeMillis()));
        taskLog.setName(flowContext.getFlowName());

        JSONObject requestData = quickFlow.getFlowConfigRequestData("定时任务全局配置");
        boolean enableTaskFlag = requestData.getBooleanValue("是否启用定时任务");
        if(!enableTaskFlag){
            flowContext.broken("根据[定时任务全局配置]参数退出定时任务");
        }
    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {
        starterDAO.log(TaskLog.class).setException(CommonUtil.exception2String(e));

        if("docker".equalsIgnoreCase(activeProfile)){
            CommonUtil.notifyMessage(starterAMSListener.applicationName()+"-定时任务-"+flowContext.getFlowName()+"-发生异常", e);
        }
    }

    @Override
    public void handleFinally(FlowContext flowContext) {
        TaskLog taskLog = starterDAO.log(TaskLog.class);
        taskLog.setFlowNameList(StringUtils.join(flowContext.getFlowNameList(), ","));
        taskLog.setFlowTrace(flowContext.getFlowTrace());
        taskLog.setRequestData(new JSONObject(flowContext.getRequestDataMap()));
        taskLog.setContextData(new JSONObject(flowContext.getContextDataMap()));
        taskLog.setEndTime(new Timestamp(System.currentTimeMillis()));
        if (null != taskLog.getStartTime()) {
            taskLog.setConsumeTime(taskLog.getEndTime().getTime() - taskLog.getStartTime().getTime());
        }
        taskLog.setBrokenReason(flowContext.getBrokenReason());
    }

    @Override
    public String name() {
        return "定时任务日志记录处理器";
    }
}
