package cn.schoolwow.quick.starter.task.sys;

import cn.schoolwow.quick.starter.flow.sys.DatabaseLogCleanFlow;
import cn.schoolwow.quickflow.QuickFlow;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class DatabaseLogCleanTask {
    @Resource
    private QuickFlow quickFlow;

    @Resource
    private ApplicationContext applicationContext;

    @Scheduled(cron = "0 0 0/1 * * *")
    public void executeTask() {
        try {
            quickFlow.executeFlow(applicationContext.getBean(DatabaseLogCleanFlow.class));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
