package cn.schoolwow.quick.starter.util;

import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.entity.log.HttpRequestLog;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSON;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class CommonUtil {
    /**当前流程id*/
    public static ThreadLocal<Long> flowIdThreadLocal = new TransmittableThreadLocal<>();

    public static HttpRequestLog getHttpRequestLog(RequestMeta requestMeta, Response response, Exception e, String source, long startTime) throws IOException {
        HttpRequestLog httpRequestLog = new HttpRequestLog();
        httpRequestLog.setFlowId(CommonUtil.flowIdThreadLocal.get());
        long endTime = System.currentTimeMillis();
        long consumeTime = endTime - startTime;
        httpRequestLog.setConsumeTime(consumeTime);

        httpRequestLog.setMethod(requestMeta.method.name());
        httpRequestLog.setUrl(URLDecoder.decode(requestMeta.url.toString(), "UTF-8"));
        httpRequestLog.setRequestHeaders(JSON.toJSONString(requestMeta.headerMap));
        if (null != requestMeta.requestBody && requestMeta.requestBody.length > 0) {
            httpRequestLog.setRequestBody(new String(requestMeta.requestBody, StandardCharsets.UTF_8));
        }
        if(null!=response){
            httpRequestLog.setResponseHeaders(JSON.toJSONString(response.responseMeta().headerMap));
            httpRequestLog.setResponseBody(URLDecoder.decode(response.body().replaceAll("%(?![0-9a-fA-F]{2})", "%25"),"UTF-8"));
        }
        if(null!=e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            httpRequestLog.setException(sw.toString());
        }
        httpRequestLog.setSource(source);
        return httpRequestLog;
    }

    public static String exception2String(Exception e) {
        if(null==e){
            return null;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static FlowLog flowContext2FlowLog(FlowContext flowContext){
        //记录流程日志
        FlowLog flowLog = new FlowLog();
        flowLog.setFlowId(flowContext.getId());
        flowLog.setName(flowContext.getFlowName());
        //保存请求数据
        flowLog.setRequestData(JSON.toJSONString(flowContext.getRequestDataMap()));
        //保存上下文数据
        flowLog.setContextData(JSON.parseObject(JSON.toJSONString(flowContext.getContextDataMap())));
        flowLog.setFlowNameList(StringUtils.join(flowContext.getFlowNameList(), ","));
        flowLog.setFlowTrace(flowContext.getFlowTrace());
        flowLog.setBrokenReason(flowContext.getBrokenReason());
        Exception e = flowContext.getFlowException();
        if(null!=e){
            flowLog.setException(CommonUtil.exception2String(e));
            flowLog.setExceptionMessage(e.getMessage());
        }
        Long startTime = (Long) flowContext.getData("__startTime");
        if(null!=startTime){
            long endTime = System.currentTimeMillis();
            flowLog.setConsumeTime(endTime-startTime);
        }
        return flowLog;
    }

    public static void notifyMessage(String title, Exception e){
        String message = e.getClass().getName()+":"+e.getMessage();
        try {
            QuickHttp.connect("https://ntfy.schoolwow.cn/error")
                    .method(Request.Method.POST)
                    .setHeader("Title", title)
                    .setHeader("Priority", "urgent")
                    .setHeader("Tags", "warning")
                    .requestBody(message)
                    .execute();
        }catch (Exception ex){
            ex.printStackTrace();
            System.out.println(message);
        }
    }
}
