userBlockMap[ams.blockConfig["projectName"]+"|starter|sys@flow_record"] = {
    "resource": {
        "fields": {
            "requestData": {
                "type": "textarea",
                "label": "请求数据",
                "props": {
                    "placeholder": "请输入请求数据"
                },
                "get": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    return val;
                },
                "view": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    if (val.length > 50) {
                        //显示前20个和后30个字符
                        return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                    }
                    return val;
                },
            }
        }
    },
    "operations": {
        "copyFlow": {
            "type": "button",
            "label": "复制流程",
            "props": {
                "type": "primary",
            },
            "event": "copyFlow list:1"
        },
        "create": {
            "slot": "rightTop",
            "type": "button",
            "label": "新增流程",
            "props": {
                "type": "primary",
            },
            "event": "addItemDialogAction list:1"
        },
        "update": {
            "type": "button",
            "label": "更新",
            "props": {
                "type": "warning",
            },
            "event": "editItemDialogAction list:1"
        },
    },
    "actions": {
        copyFlow(params){
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.addItemDialog(this,"/create",fields, {
                "path": "/create",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
        addItemDialogAction(params) {
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.addItemDialog(this,"/create",fields, {
                "path": "/create",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
        editItemDialogAction(params) {
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["categoryName", "name", "flowNameList", "requestData"]);
            return ams.utils.editItemDialog(this,"/edit",fields, {
                "path": "/edit",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
    }
};