/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.ams.controller.mall;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quick.starter.domain.ams.DiagnoseFlow;
import cn.schoolwow.quick.starter.domain.ams.DiagnoseRequest;
import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams/api"})
public class DiagnoseController {
    @Resource
    private DAO starterDAO;
    @Resource
    private QuickFlow quickFlow;
    @Autowired(required=false)
    private List<DiagnoseFlow> diagnoseFlowList;
    @Resource
    private AMSListener starterAMSListener;

    @RequestMapping(value={"/{projectName}/clazz/diagnose/list"})
    public JSONObject list(@PathVariable(value="projectName") String projectName, @RequestParam Map<String, Object> requestParam) {
        if (!this.starterAMSListener.projectName().equals(projectName)) {
            throw new IllegalArgumentException("\u9879\u76ee\u540d\u4e0d\u5339\u914d!");
        }
        JSONObject request = new JSONObject(requestParam);
        DiagnoseRequest diagnoseRequest = (DiagnoseRequest)request.toJavaObject(DiagnoseRequest.class);
        Validate.notEmpty((CharSequence)diagnoseRequest.type, (String)"\u6d41\u7a0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (null == this.diagnoseFlowList || this.diagnoseFlowList.isEmpty()) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u7c7b\u578b!\u6d41\u7a0b\u7c7b\u578b:" + diagnoseRequest.type);
        }
        DiagnoseFlow selectedDiagnoseFlow = null;
        for (DiagnoseFlow diagnoseFlow : this.diagnoseFlowList) {
            if (!diagnoseFlow.name().equalsIgnoreCase(diagnoseRequest.type)) continue;
            selectedDiagnoseFlow = diagnoseFlow;
            break;
        }
        if (null == selectedDiagnoseFlow) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u7c7b\u578b!\u6d41\u7a0b\u7c7b\u578b:" + diagnoseRequest.type);
        }
        long startTime = System.currentTimeMillis();
        request.remove((Object)"type");
        request.remove((Object)"value");
        request.remove((Object)"page");
        request.remove((Object)"pageSize");
        this.starterDAO.recordSqlLog(false);
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)selectedDiagnoseFlow).putTemporaryData("diagnoseRequest", (Object)diagnoseRequest).putTemporaryData((Map)request).execute();
        this.starterDAO.recordSqlLog(true);
        JSONArray list = new JSONArray();
        FlowLog flowLog = CommonUtil.flowContext2FlowLog(flowContext);
        flowLog.setContextData(JSON.parseObject((String)JSON.toJSONString((Object)flowContext.getData())));
        flowLog.setConsumeTime(System.currentTimeMillis() - startTime);
        flowLog.setCreatedAt(LocalDateTime.now());
        flowLog.setUpdatedAt(LocalDateTime.now());
        list.add((Object)flowLog);
        return AMSUtil.getAMSList((Collection)list);
    }

    @RequestMapping(value={"/placeholder"})
    public Map<String, String> placeholder() {
        HashMap<String, String> placeHolderMap = new HashMap<String, String>();
        if (null != this.diagnoseFlowList) {
            for (DiagnoseFlow diagnoseFlow : this.diagnoseFlowList) {
                if (!StringUtils.isNotBlank((CharSequence)diagnoseFlow.placeholder())) continue;
                placeHolderMap.put(diagnoseFlow.name(), diagnoseFlow.placeholder());
            }
        }
        return placeHolderMap;
    }
}

