/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.ams.listener.clazz.database;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quick.starter.domain.ams.database.DatabaseIndexField;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DatabaseIndexFieldClazzListener
implements AMSClazzListenerAware {
    @Resource
    private DAO starterDAO;
    @Resource
    private AMSListener starterAMSListener;

    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener().projectName(this.starterAMSListener.projectName()).className("DatabaseIndexField").list(new ListClazzListener(){

            public JSONObject list(Map<String, Object> amsListConditionMap) {
                JSONObject amsCondition = new JSONObject(amsListConditionMap);
                DatabaseIndexField databaseIndexFieldCondition = (DatabaseIndexField)amsCondition.toJavaObject(DatabaseIndexField.class);
                List entityList = DatabaseIndexFieldClazzListener.this.starterDAO.getDatabaseEntityList();
                ArrayList<DatabaseIndexField> databaseIndexFieldList = new ArrayList<DatabaseIndexField>();
                for (Entity entity : entityList) {
                    for (IndexField indexField : entity.indexFieldList) {
                        int indexType = -1;
                        switch (indexField.indexType) {
                            case NORMAL: {
                                indexType = 0;
                                break;
                            }
                            case UNIQUE: {
                                indexType = 1;
                                break;
                            }
                            case FULLTEXT: {
                                indexType = 2;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7d22\u5f15\u7c7b\u578b!\u7d22\u5f15\u7c7b\u578b:" + indexField.indexType.name());
                            }
                        }
                        if (null != databaseIndexFieldCondition && (StringUtils.isNotBlank((CharSequence)databaseIndexFieldCondition.tableName) && !indexField.tableName.matches(databaseIndexFieldCondition.tableName) || null != databaseIndexFieldCondition.indexType && indexType != databaseIndexFieldCondition.indexType || StringUtils.isNotBlank((CharSequence)databaseIndexFieldCondition.indexName) && !indexField.indexName.matches(databaseIndexFieldCondition.indexName) || StringUtils.isNotBlank((CharSequence)databaseIndexFieldCondition.using) && !indexField.using.matches(databaseIndexFieldCondition.using) || StringUtils.isNotBlank((CharSequence)databaseIndexFieldCondition.comment) && !indexField.comment.matches(databaseIndexFieldCondition.comment) || StringUtils.isNotBlank((CharSequence)databaseIndexFieldCondition.columns) && !indexField.columns.contains(databaseIndexFieldCondition.columns))) continue;
                        DatabaseIndexField databaseIndexField = new DatabaseIndexField();
                        databaseIndexField.tableName = indexField.tableName;
                        databaseIndexField.indexName = indexField.indexName;
                        databaseIndexField.indexType = indexType;
                        databaseIndexField.using = indexField.using;
                        databaseIndexField.columns = indexField.columns.toString();
                        databaseIndexField.comment = indexField.comment;
                        databaseIndexFieldList.add(databaseIndexField);
                    }
                }
                return AMSUtil.getAMSList(databaseIndexFieldList);
            }
        }));
    }
}

