/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.entity.log.HttpRequestLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ExecuteHttpRequestOperation
implements AMSOperationAware {
    @Resource
    private DAO starterDAO;
    @Resource
    private AMSListener starterAMSListener;

    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation().projectName(this.starterAMSListener.projectName()).daoName("starter").tableName("log@http_request_log").methodName("executeHttpRequest").name("\u6267\u884cHTTP\u8bf7\u6c42").fieldNameList(new String[0]).handle(new HandleOperation(){

            public JSONObject handle(String methodName, JSONObject data) throws Exception {
                HttpRequestLog executeHttpRequestLog = (HttpRequestLog)data.toJavaObject(HttpRequestLog.class);
                JSONObject requestHeaders = JSON.parseObject((String)executeHttpRequestLog.getRequestHeaders());
                HashMap<String, List> requestHeaderMap = new HashMap<String, List>();
                Set keySet = requestHeaders.keySet();
                for (String key : keySet) {
                    requestHeaderMap.put(key, requestHeaders.getJSONArray(key).toJavaList(String.class));
                }
                Request request = QuickHttp.connect((String)executeHttpRequestLog.getUrl()).method(executeHttpRequestLog.getMethod()).headers(requestHeaderMap);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{executeHttpRequestLog.getRequestBody()})) {
                    request.requestBody(executeHttpRequestLog.getRequestBody());
                }
                long startTime = System.currentTimeMillis();
                Response response = null;
                Exception ex = null;
                try {
                    response = request.execute();
                }
                catch (Exception e) {
                    ex = e;
                    throw e;
                }
                finally {
                    HttpRequestLog httpRequestLog = CommonUtil.getHttpRequestLog(request.getRequestMeta(), response, ex, executeHttpRequestLog.getSource(), startTime);
                    ExecuteHttpRequestOperation.this.starterDAO.insert((Object)httpRequestLog);
                }
                return null;
            }
        }));
    }
}

