/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.ams.listener.operation.sys;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.entity.sys.FlowRecord;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ResetFlowRecordOperationTemplate
implements AMSOperationAware {
    @Resource
    private DAO starterDAO;
    @Resource
    private AMSListener starterAMSListener;
    @Resource
    private QuickFlow quickFlow;
    @Autowired(required=false)
    private List<CompositeBusinessFlow> compositeBusinessFlowList;

    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation().projectName(this.starterAMSListener.projectName()).daoName("starter").tableName("sys@flow_record").methodName("reset").position(AMSOperationPosition.RightTop).name("\u91cd\u7f6e\u6d41\u7a0b").handle(new HandleOperation(){

            public JSONObject handle(String methodName, JSONObject data) throws Exception {
                ResetFlowRecordOperationTemplate.this.resetFlowRecord();
                return null;
            }
        }));
    }

    protected abstract Map<String, String> getPackageNameCategoryNameMap();

    protected void resetFlowRecord() {
        Map<String, String> packageNameCategoryNameMap = this.getPackageNameCategoryNameMap();
        this.starterDAO.query(FlowRecord.class).addInQuery("categoryName", packageNameCategoryNameMap.values()).execute().delete();
        ArrayList<FlowRecord> flowRecordList = new ArrayList<FlowRecord>();
        for (Map.Entry<String, String> entry : packageNameCategoryNameMap.entrySet()) {
            for (CompositeBusinessFlow compositeBusinessFlow : this.compositeBusinessFlowList) {
                String className = compositeBusinessFlow.getClass().getName();
                if (!className.startsWith(entry.getKey())) continue;
                FlowRecord flowRecord = new FlowRecord();
                flowRecord.setCategoryName(entry.getValue());
                QuickFlowExecutor quickFlowExecutor = this.quickFlow.startFlow(compositeBusinessFlow.name());
                compositeBusinessFlow.executeCompositeBusiness(quickFlowExecutor);
                FlowExecutorOption flowExecutorOption = quickFlowExecutor.getOption();
                flowRecord.setName(flowExecutorOption.name);
                flowRecord.setFlowNameList(StringUtils.join((Iterable)flowExecutorOption.flowNameList, (String)","));
                flowRecord.setRequestData(new JSONObject(flowExecutorOption.requestData));
                flowRecordList.add(flowRecord);
            }
        }
        try {
            this.starterDAO.updateType(UpdateType.UpdateByUniqueKey).save(flowRecordList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

