/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.ams.listener.table.sys;

import cn.schoolwow.ams.domain.listener.table.AMSTableListener;
import cn.schoolwow.ams.domain.listener.table.BeforeEditOption;
import cn.schoolwow.ams.domain.listener.table.CreateTable;
import cn.schoolwow.ams.domain.listener.table.DeleteTable;
import cn.schoolwow.ams.domain.listener.table.EditTable;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSTableListenerAware;
import cn.schoolwow.quick.starter.entity.sys.ProjectFlowConfig;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProjectFlowConfigTableListener
implements AMSTableListenerAware {
    @Resource
    private QuickFlow quickFlow;
    @Resource
    private AMSListener starterAMSListener;

    public List<AMSTableListener> getAMSTableListenerList() {
        return Arrays.asList(new AMSTableListener().projectName(this.starterAMSListener.projectName()).daoName("starter").tableName("sys@project_flow_config").createTable(new CreateTable(){

            public void beforeCreate(JSONObject createEntity) throws Exception {
            }

            public void afterCreate(JSONObject createEntity) throws Exception {
                ProjectFlowConfig projectFlowConfig = (ProjectFlowConfig)createEntity.toJavaObject(ProjectFlowConfig.class);
                ProjectFlowConfigTableListener.this.quickFlow.getFlowConfigRequestData(projectFlowConfig.getName()).putAll((Map)projectFlowConfig.getRequestData());
            }
        }).editTable(new EditTable(){

            public BeforeEditOption beforeEdit(JSONObject updateEntity) throws Exception {
                BeforeEditOption beforeEditOption = new BeforeEditOption();
                beforeEditOption.partColumnArray = new String[]{"requestData"};
                return beforeEditOption;
            }

            public void afterEdit(BeforeEditOption beforeEditOption, JSONObject updateEntity) throws Exception {
                ProjectFlowConfig projectFlowConfig = (ProjectFlowConfig)updateEntity.toJavaObject(ProjectFlowConfig.class);
                ProjectFlowConfigTableListener.this.quickFlow.getFlowConfigRequestData(projectFlowConfig.getName()).putAll((Map)projectFlowConfig.getRequestData());
            }
        }).deleteTable(new DeleteTable(){

            public void beforeDelete(Condition condition, JSONObject amsListCondition) throws Exception {
            }

            public void afterDelete(Condition condition, JSONObject amsListCondition) throws Exception {
                List nameList = condition.addColumn(new String[]{"name"}).execute().getSingleColumnList(String.class);
                for (String name : nameList) {
                    ((ProjectFlowConfigTableListener)ProjectFlowConfigTableListener.this).quickFlow.getFlowConfig().flowConfigRequestDataMap.remove(name);
                }
            }
        }));
    }
}

