/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.config.flow;

import cn.schoolwow.quick.starter.entity.sys.ProjectFlowConfig;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickflow.listener.FlowConfigRequestDataHandler;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StarterFlowConfigMapListener
implements FlowConfigRequestDataHandler {
    @Resource
    private DAO starterDAO;

    public Map<String, JSONObject> loadFlowConfigRequestDataMap() {
        List projectFlowConfigList = this.starterDAO.query(ProjectFlowConfig.class).execute().getList();
        HashMap<String, JSONObject> flowConfigMap = new HashMap<String, JSONObject>();
        for (ProjectFlowConfig projectFlowConfig : projectFlowConfigList) {
            flowConfigMap.put(projectFlowConfig.getName(), projectFlowConfig.getRequestData());
        }
        return flowConfigMap;
    }

    public void saveFlowConfigRequestData(String flowName, JSONObject requestData) {
        ProjectFlowConfig projectFlowConfig = new ProjectFlowConfig();
        projectFlowConfig.setName(flowName);
        projectFlowConfig.setRequestData(requestData);
        if (!this.starterDAO.exist((Object)projectFlowConfig)) {
            this.starterDAO.insert((Object)projectFlowConfig);
        }
        JSONObject databaseRequestData = (JSONObject)this.starterDAO.query(ProjectFlowConfig.class).addQuery("name", (Object)projectFlowConfig.getName()).addColumn(new String[]{"requestData"}).setColumnTypeMap("requestData", JSONObject.class).execute().getSingleColumn(JSONObject.class);
        this.putIncrementConfig(requestData, databaseRequestData);
        this.starterDAO.updateType(UpdateType.UpdateByUniqueKey).update((Object)projectFlowConfig);
    }

    private void putIncrementConfig(JSONObject source, JSONObject target) {
        if (null == target) {
            return;
        }
        Set keySet = source.keySet();
        for (String key : keySet) {
            if (source.get((Object)key) instanceof JSONObject) {
                this.putIncrementConfig(source.getJSONObject(key), target.getJSONObject(key));
                continue;
            }
            if (!target.containsKey((Object)key)) continue;
            source.put(key, target.get((Object)key));
        }
    }
}

