/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.config.flow;

import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.quickflow.listener.BeforeAfterFlowHandler;
import cn.schoolwow.quickflow.listener.FlowMappingHandler;
import cn.schoolwow.quickflow.listener.SingleFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class StarterMallFlowMappingHandler
implements FlowMappingHandler {
    private Logger logger = LoggerFactory.getLogger(StarterMallFlowMappingHandler.class);
    @Resource
    private ApplicationContext applicationContext;

    public BusinessFlow getFlow(String flowName) {
        Map beanMap = this.applicationContext.getBeansOfType(BusinessFlow.class);
        HashMap<String, BusinessFlow> flowNameMap = new HashMap<String, BusinessFlow>();
        HashSet<String> repeatFlowNameSet = new HashSet<String>();
        for (BusinessFlow businessFlow : beanMap.values()) {
            String name = businessFlow.name();
            if (flowNameMap.containsKey(name)) {
                repeatFlowNameSet.add(name);
            }
            flowNameMap.put(name, businessFlow);
        }
        if (!repeatFlowNameSet.isEmpty()) {
            this.logger.info("\u5b58\u5728\u91cd\u540d\u6d41\u7a0b!" + repeatFlowNameSet);
            throw new IllegalArgumentException("\u5b58\u5728\u91cd\u540d\u6d41\u7a0b!\u91cd\u540d\u6d41\u7a0b\u4e2a\u6570:" + repeatFlowNameSet.size());
        }
        if (flowNameMap.containsKey(flowName)) {
            return (BusinessFlow)flowNameMap.get(flowName);
        }
        return null;
    }

    public CompositeBusinessFlow getCompositeBusinessFlow(String flowName) {
        Map beanMap = this.applicationContext.getBeansOfType(CompositeBusinessFlow.class);
        HashMap<String, CompositeBusinessFlow> flowNameMap = new HashMap<String, CompositeBusinessFlow>();
        HashSet<String> repeatFlowNameSet = new HashSet<String>();
        for (CompositeBusinessFlow compositeBusinessFlow : beanMap.values()) {
            String name = compositeBusinessFlow.name();
            if (flowNameMap.containsKey(name)) {
                repeatFlowNameSet.add(name);
            }
            flowNameMap.put(name, compositeBusinessFlow);
        }
        if (!repeatFlowNameSet.isEmpty()) {
            this.logger.info("\u5b58\u5728\u91cd\u540d\u6d41\u7a0b!" + repeatFlowNameSet);
            throw new IllegalArgumentException("\u5b58\u5728\u91cd\u540d\u6d41\u7a0b!\u91cd\u540d\u6d41\u7a0b\u4e2a\u6570:" + repeatFlowNameSet.size());
        }
        if (flowNameMap.containsKey(flowName)) {
            return (CompositeBusinessFlow)flowNameMap.get(flowName);
        }
        return null;
    }

    public TryCatchFinallyHandler getTryCatchFinallyHandler(String handlerName) {
        Map beanMap = this.applicationContext.getBeansOfType(TryCatchFinallyHandler.class);
        for (TryCatchFinallyHandler tryCatchFinallyHandler : beanMap.values()) {
            if (!tryCatchFinallyHandler.name().equalsIgnoreCase(handlerName)) continue;
            return tryCatchFinallyHandler;
        }
        throw new IllegalArgumentException("tryCatchFinally\u5904\u7406\u5668\u540d\u79f0\u5bf9\u5e94\u5904\u7406\u5668\u4e0d\u5b58\u5728!\u540d\u79f0:" + handlerName);
    }

    public BeforeAfterFlowHandler getBeforeAfterHandler(String handlerName) {
        Map beanMap = this.applicationContext.getBeansOfType(BeforeAfterFlowHandler.class);
        for (BeforeAfterFlowHandler beforeAfterFlowHandler : beanMap.values()) {
            if (!beforeAfterFlowHandler.name().equalsIgnoreCase(handlerName)) continue;
            return beforeAfterFlowHandler;
        }
        throw new IllegalArgumentException("beforeAfter\u5904\u7406\u5668\u540d\u79f0\u5bf9\u5e94\u5904\u7406\u5668\u4e0d\u5b58\u5728!\u540d\u79f0:" + handlerName);
    }

    public SingleFlowListener getSingleFlowListener(String handlerName) {
        Map beanMap = this.applicationContext.getBeansOfType(SingleFlowListener.class);
        for (SingleFlowListener singleFlowListener : beanMap.values()) {
            if (!singleFlowListener.name().equalsIgnoreCase(handlerName)) continue;
            return singleFlowListener;
        }
        throw new IllegalArgumentException("singleFlow\u5904\u7406\u5668\u540d\u79f0\u5bf9\u5e94\u5904\u7406\u5668\u4e0d\u5b58\u5728!\u540d\u79f0:" + handlerName);
    }
}

