/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.config.flow;

import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StarterMallTryCatchFinallyHandler
implements TryCatchFinallyHandler {
    private Logger logger = LoggerFactory.getLogger(StarterMallTryCatchFinallyHandler.class);
    @Resource
    private DAO starterDAO;

    public void handleTry(FlowContext flowContext) {
        flowContext.putTemporaryData("__startTime", (Object)System.currentTimeMillis());
        CommonUtil.flowIdThreadLocal.set(flowContext.getId());
    }

    public void handleException(FlowContext flowContext, Exception e) {
    }

    public void handleFinally(FlowContext flowContext) {
        this.starterDAO.insertLog();
        Boolean recordLog = (Boolean)flowContext.getData("recordLog");
        if (null != recordLog && !recordLog.booleanValue()) {
            return;
        }
        if (flowContext.getFlowExecutorRootConfig().flowConfig.debug) {
            this.logger.info("\r\n" + flowContext.getFlowTrace());
        }
        FlowLog flowLog = CommonUtil.flowContext2FlowLog(flowContext);
        this.starterDAO.insert((Object)flowLog);
    }

    public String name() {
        return "\u5168\u5c40\u6d41\u7a0b\u4e8b\u4ef6\u5904\u7406";
    }
}

