/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.flow.ams;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecuteFlow
implements BusinessFlow {
    @Resource
    private QuickFlow quickFlow;
    @Autowired(required=false)
    private List<CompositeBusinessFlow> compositeBusinessFlowList;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject data = (JSONObject)flowContext.checkData("data");
        JSONArray flowList = data.getJSONArray("list");
        for (int i = 0; i < flowList.size(); ++i) {
            JSONObject flow = flowList.getJSONObject(i);
            String name = flow.getString("name");
            JSONObject requestData = flow.getJSONObject("requestData");
            for (CompositeBusinessFlow compositeBusinessFlow : this.compositeBusinessFlowList) {
                String compositeBusinessName = compositeBusinessFlow.name();
                if (!name.equalsIgnoreCase(compositeBusinessName)) continue;
                QuickFlowExecutor quickFlowExecutor = this.quickFlow.startFlow(compositeBusinessFlow);
                if (null != requestData) {
                    quickFlowExecutor.putTemporaryData((Map)requestData);
                }
                quickFlowExecutor.execute();
                return;
            }
            Validate.isTrue((boolean)flow.containsKey((Object)"flowNameList"), (String)"\u6d41\u7a0b\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            FlowExecutorOption flowExecutorOption = new FlowExecutorOption();
            flowExecutorOption.name = name;
            flowExecutorOption.flowNameList = Arrays.asList(flow.getString("flowNameList").split(",", -1));
            if (null != requestData) {
                flowExecutorOption.requestData.putAll(requestData);
            }
            this.quickFlow.startFlow(flowExecutorOption).execute();
        }
    }

    public String name() {
        return "\u6267\u884c\u6d41\u7a0b";
    }
}

