/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.flow.sys;

import cn.schoolwow.data.thread.QuickDataThread;
import cn.schoolwow.data.thread.work.single.SingleDataThreadHandler;
import cn.schoolwow.data.thread.work.single.SingleDataThreadWork;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.HasFlowConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class DatabaseLogCleanFlow
implements BusinessFlow,
HasFlowConfig {
    @Resource
    private DAO starterDAO;
    @Resource
    private QuickDataThread quickDataThread;

    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        JSONArray tableNameArray = (JSONArray)flowContext.checkData("\u6e05\u7406\u6570\u636e\u5e93\u8868\u540d");
        List tableNameList = tableNameArray.toJavaList(String.class);
        Integer remainDays = (Integer)flowContext.checkData("\u4fdd\u5b58\u65e5\u5fd7\u5929\u6570");
        Validate.isTrue((remainDays > 3 ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u65e5\u5fd7\u5929\u6570\u81f3\u5c11\u5927\u4e8e3", (Object[])new Object[0]);
        final LocalDate time = LocalDate.now().minusDays(remainDays.intValue());
        this.quickDataThread.executeSingleDataThreadWork(new SingleDataThreadWork("\u6e05\u7406\u6570\u636e\u5e93\u8868").list(tableNameList).singleDataThreadHandler((SingleDataThreadHandler)new SingleDataThreadHandler<String>(){

            public void handleSingleList(String tableName) throws Exception {
                int effect = DatabaseLogCleanFlow.this.starterDAO.query(tableName).addQuery("created_at", "<", (Object)time).execute().delete();
                flowContext.putData(tableName + "DeleteEffect", (Object)effect);
            }
        }));
    }

    public String name() {
        return "\u6570\u636e\u5e93\u65e5\u5fd7\u5b9a\u65f6\u6e05\u7406";
    }

    public void setRequestData(JSONObject requestData) {
        requestData.put("\u6e05\u7406\u6570\u636e\u5e93\u8868\u540d", Arrays.asList("log@flow_log", "log@http_request_log", "log@task_log"));
        requestData.put("\u4fdd\u5b58\u65e5\u5fd7\u5929\u6570", (Object)14);
    }
}

