/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quick.starter.flow.task;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quick.starter.entity.log.TaskLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskLogTryCatchFinallyHandler
implements TryCatchFinallyHandler {
    @Value(value="${spring.profiles.active}")
    private String activeProfile;
    @Resource
    private DAO starterDAO;
    @Resource
    private AMSListener starterAMSListener;
    @Resource
    private QuickFlow quickFlow;

    @PostConstruct
    public void postConstruct() {
        JSONObject requestData = new JSONObject();
        requestData.put("\u662f\u5426\u542f\u7528\u5b9a\u65f6\u4efb\u52a1", (Object)true);
        this.quickFlow.saveFlowConfigRequestData("\u5b9a\u65f6\u4efb\u52a1\u5168\u5c40\u914d\u7f6e", requestData);
    }

    public void handleTry(FlowContext flowContext) {
        TaskLog taskLog = (TaskLog)this.starterDAO.log(TaskLog.class);
        taskLog.setFlowId(flowContext.getId());
        taskLog.setStartTime(new Timestamp(System.currentTimeMillis()));
        taskLog.setName(flowContext.getFlowName());
        JSONObject requestData = this.quickFlow.getFlowConfigRequestData("\u5b9a\u65f6\u4efb\u52a1\u5168\u5c40\u914d\u7f6e");
        boolean enableTaskFlag = requestData.getBooleanValue("\u662f\u5426\u542f\u7528\u5b9a\u65f6\u4efb\u52a1");
        if (!enableTaskFlag) {
            flowContext.broken("\u6839\u636e[\u5b9a\u65f6\u4efb\u52a1\u5168\u5c40\u914d\u7f6e]\u53c2\u6570\u9000\u51fa\u5b9a\u65f6\u4efb\u52a1");
        }
    }

    public void handleException(FlowContext flowContext, Exception e) {
        ((TaskLog)this.starterDAO.log(TaskLog.class)).setException(CommonUtil.exception2String(e));
        if ("docker".equalsIgnoreCase(this.activeProfile)) {
            CommonUtil.notifyMessage(this.starterAMSListener.applicationName() + "-\u5b9a\u65f6\u4efb\u52a1-" + flowContext.getFlowName() + "-\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public void handleFinally(FlowContext flowContext) {
        TaskLog taskLog = (TaskLog)this.starterDAO.log(TaskLog.class);
        taskLog.setFlowNameList(StringUtils.join((Iterable)flowContext.getFlowNameList(), (String)","));
        taskLog.setFlowTrace(flowContext.getFlowTrace());
        taskLog.setRequestData(new JSONObject(flowContext.getRequestDataMap()));
        taskLog.setContextData(new JSONObject(flowContext.getContextDataMap()));
        taskLog.setEndTime(new Timestamp(System.currentTimeMillis()));
        if (null != taskLog.getStartTime()) {
            taskLog.setConsumeTime(taskLog.getEndTime().getTime() - taskLog.getStartTime().getTime());
        }
        taskLog.setBrokenReason(flowContext.getBrokenReason());
    }

    public String name() {
        return "\u5b9a\u65f6\u4efb\u52a1\u65e5\u5fd7\u8bb0\u5f55\u5904\u7406\u5668";
    }
}

