userBlockMap[ams.blockConfig["projectName"]+"|starter|log@flow_log"] = {
    "operations": {
        "logOption": {
            "label": "日志类型",
            "slot": "searchs",
            "type": "field",
            "field": {
                "type": "select",
                "props": {
                    "multiple": false,
                    "clearable": true,
                    "placeholder": "请选择类型",
                    "options": {
                        "0": "全部",
                        "1": "正常日志",
                        "2": "异常日志",
                        "3": "中断日志",
                    }
                },
            },
        },
        "addFlowLogRowButton": {
            "type": "button",
            "label": "手动执行流程",
            "props": {
                "type": "primary",
            },
            "event": "addItemDialogAction list:1"
        },
        "addToFlowRecord": {
            "type": "button",
            "label": "添加到流程记录",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认添加吗? addToFlowRecord"
        },
    },
    "actions":{
        addTestFlowLogRightTop(){
            return ams.utils.sendRequestWithResponse(this,{
                "method": "POST",
                "url": "/addTestFlowLog",
            }, (response)=>{
                let o = response.data;
                this.$message.success("本次插入"+o["effect"]+",期望总个数:"+o["expect"]+",当前总个数:"+o["count"]);
            });
        },
        addItemDialogAction(params) {
            let row = params.$prevReturn;
            row.contextData = JSON.stringify(row.contextData);
            let fields = ams.utils.getResourceFields(this, ["name","requestData","flowNameList"]);
            return ams.utils.addItemDialog(this,"/manualExecuteFlow",fields);
        },
        addToFlowRecord(params){
            let row = params.$prevReturn;
            let data = {
                "categoryName": "流程日志",
                "name": row["name"],
                "requestData": JSON.parse(row["requestData"]),
                "flowNameList": row["flowNameList"],
            };
            return ams.utils.sendRequestWithTableName(this,ams.blockConfig["projectName"],"sys@flow_record", {
                "method": "POST",
                "url": "/create",
                "data": data
            }, "流程记录添加完毕");
        },
    }
};
