userBlockMap[ams.blockConfig["projectName"]+"|clazz|diagnose"] = {
    "operations": {
        "count": {
            "label": "处理个数",
            "slot": "searchs",
            "type": "field",
            "field": {
                "type": "select",
                "props": {
                    "multiple": false,
                    "clearable": true,
                    "placeholder": "请选择处理个数",
                    "options": {
                        "1": "1",
                        "5": "5",
                        "10": "10",
                        "100": "100",
                        "1000": "1000",
                    }
                },
            },
        },
        "times": {
            "label": "次数",
            "slot": "searchs",
            "type": "field",
            "field": {
                "type": "select",
                "props": {
                    "multiple": false,
                    "clearable": true,
                    "placeholder": "请选择次数",
                    "options": {
                        "1": "1",
                        "5": "5",
                        "10": "10",
                        "100": "100",
                    }
                },
            },
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "诊断",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认执行吗? list:1",
        },
    },
    "events": {
        "init": "initialPlaceHolder initialCondition"
    },
    "actions": {
        initialPlaceHolder(){
            let prefix = this.resource.api.prefix;
            return ams.request({
                "method": "GET",
                "url": prefix + "/placeholder",
            }).then((response)=>{
                this["data"]["placeholder"] = response.data.data;
            });
        },
        fieldChange({field,name, value,path}) {
            if(name==="type"){
                let placeholder = this["data"]["placeholder"];
                if(placeholder.hasOwnProperty(value)){
                    let valueField = this["block"]["operations"]["value"]["field"];
                    valueField["props"]["placeholder"] = placeholder[value];
                    valueField["info"] = placeholder[value];
                }
                this["data"]["searchs"][name] = value;
            }
        },
    }
};