userBlockMap[ams.blockConfig["projectName"]+"|starter|sys@project_flow_config"] = {
    "resource": {
        "fields": {
            "requestData": {
                "type": "textarea",
                "label": "请求数据",
                "props": {
                    "placeholder": "请输入请求数据"
                },
                "get": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    return val;
                },
                "view": function (val, field, row) {
                    if (null == val) {
                        return;
                    }
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    if (val.length > 50) {
                        //显示前20个和后30个字符
                        return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                    }
                    return val;
                },
            }
        }
    },
    "operations": {
        "update": {
            "type": "button",
            "label": "更新",
            "props": {
                "type": "warning",
            },
            "event": "editItemDialogAction list:1"
        },
    },
    "actions": {
        editItemDialogAction(params) {
            let block = this;
            let fields = ams.utils.getResourceFields(this, ["name", "requestData"]);
            ams.utils.disabledResourceFields(fields, ["name"]);
            return ams.utils.editItemDialog(this,"/edit",fields, {
                "path": "/edit",
                requestDataParse(data) {
                    try {
                        if (typeof (data.requestData) == "string") {
                            data.requestData = JSON.parse(data.requestData);
                        }
                    }catch (e) {
                        block.$message.error("请求数据不是合法的JSONObject格式");
                    }
                    return data;
                },
            });
        },
    }
};