package cn.shazhengbo.storage.entity;

import cn.shazhengbo.kafka.annotation.KafkaDealState;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @author CrazyShaQiuShi
 * @version 1.0
 * @description: 消息组
 * @date 2020/8/23 7:04
 */
@Getter
@Setter
@TableName(value = "event_consumer_group")
public class MessageConsumerGroup {
    /**
     * 序号
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 版本号
     */
    @Version
    private long version;
    /**
     * 版本号
     */
    @TableField(value = "uuid_")
    private String uuid_;
    /**
     * 处理状态
     */
    private int state;
    /**
     * 组偏移量
     */
    @TableField(value = "off_set_")
    private long offSet_;
    /**
     * 特定消费组
     */
    @TableField(value = "consumer_group_")
    private String consumerGroup_;
    /**
     * 上一次处理时间
     */
    private LocalDateTime lastDealTime;
    /**
     * 下次发送时间
     */
    protected LocalDateTime nextSendTime;

    /**
     * 构建确认处理对象
     *
     * @param offSet
     * @param uuid
     * @param consumerGroup
     */
    public void ack(long offSet, String uuid, String consumerGroup) {
        this.offSet_ = offSet;
        this.uuid_ = uuid;
        this.consumerGroup_ = consumerGroup;
        this.lastDealTime = LocalDateTime.now();
        this.nextSendTime = LocalDateTime.now();
        this.state = KafkaDealState.SUCCESS.ordinal();
    }

    public void fail(long offSet, String uuid, String consumerGroup, LocalDateTime nextSendTime) {
        this.uuid_ = uuid;
        this.offSet_ = offSet;
        this.consumerGroup_ = consumerGroup;
        this.lastDealTime = LocalDateTime.now();
        this.state = KafkaDealState.FAIL.ordinal();
        this.nextSendTime = nextSendTime;
    }
}
