package cn.shazhengbo.storage.entity;


import cn.shazhengbo.kafka.annotation.BaseGlobalEntity;
import cn.shazhengbo.kafka.annotation.KafkaAckType;
import cn.shazhengbo.kafka.annotation.KafkaMessageState;
import cn.shazhengbo.kafka.annotation.KafkaMessageType;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yqtsoft.framework.common.entity.AuditingEntity;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

/**
 * @author CrazyShaQiuShi
 * @version 1.0
 * @description 消息体
 * @date 2020/8/22 20:09
 */
@Getter
@Setter
@TableName(value = "event_entry")
public class MessageEventEntery extends AuditingEntity {
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 消息中的uuid
     */
    @TableField(value = "uuid_")
    private String uuid_;
    /**
     * 是否关联父id
     */
    private long parentId;
    /**
     * 消息体
     */
    private String eventMessage;
    /**
     * 消息类型
     */
    private int eventType;
    /**
     * 确认方式
     */
    private int ackType;
    /**
     * 当前topic
     */
    private String topic;
    /**
     * 消息已发送次数
     */
    private int sendTimes;
    /**
     * 最多发送次数
     */
    private int retries;
    /**
     * 发送状态
     */
    private int state;
    /**
     * 当前组:若次值为null,则代表所有组通用
     */
    @TableField(value = "consumer_group_")
    private String consumerGroup_;
    /**
     * 下次发送时间
     */
    private LocalDateTime nextSendTime;

    /**
     * 构建消息体
     *
     * @param topic
     * @param retries
     * @param type
     * @param ackType
     * @param message
     */
    public void created(String topic, int retries, KafkaMessageType type, KafkaAckType ackType, String message) {
        this.topic = topic;
        this.retries = retries;
        this.uuid_ = value(BaseGlobalEntity.GLOBAL_ID, message);
        this.consumerGroup_ = value(BaseGlobalEntity.CONSUMER_GROUP, message);
        this.eventMessage = message;
        this.eventType = type.ordinal();
        this.ackType = ackType.ordinal();
        this.sendTimes = 0;
        this.retries = retries;
        this.state = KafkaMessageState.READY.ordinal();
        this.nextSendTime = LocalDateTime.now().minusSeconds(3);
    }

    private static String value(String key, String message) {
        Map<String, Object> map = JsonHelper.resolve(message, Map.class);
        Object value = map.get(key);
        return value == null ? null : String.valueOf(value);
    }

    public void modified(KafkaMessageState state) {
        this.state = state.ordinal();
        this.sendTimes = sendTimes + 1;
        /**
         * 等待时间即为,次数的三次方
         */
        this.nextSendTime = LocalDateTime.now().plusMinutes((long) Math.pow(sendTimes, 3));
    }

    /**
     * 构建重发对象
     */
    public void retry(String consumerGroup, int count) {
        if (this.parentId == 0) {
            this.parentId = id;
        }
        this.id = null;
        this.setUuid_(UUID.randomUUID().toString());
        this.sendTimes = 0;
        this.nextSendTime = LocalDateTime.now().plusMinutes((long) Math.pow(count + 1, 3));
        this.setVersion(0);
        this.state = KafkaMessageState.READY.ordinal();
        this.consumerGroup_ = consumerGroup;
    }
}
