/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.storage.entity;

import cn.shazhengbo.kafka.annotation.KafkaAckType;
import cn.shazhengbo.kafka.annotation.KafkaMessageState;
import cn.shazhengbo.kafka.annotation.KafkaMessageType;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yqtsoft.framework.common.entity.AuditingEntity;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

@TableName(value="event_entry")
public class MessageEventEntery
extends AuditingEntity {
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(value="uuid_")
    private String uuid_;
    private long parentId;
    private String eventMessage;
    private int eventType;
    private int ackType;
    private String topic;
    private int sendTimes;
    private int retries;
    private int state;
    @TableField(value="consumer_group_")
    private String consumerGroup_;
    private LocalDateTime nextSendTime;

    public void created(String topic, int retries, KafkaMessageType type, KafkaAckType ackType, String message) {
        this.topic = topic;
        this.retries = retries;
        this.uuid_ = MessageEventEntery.value("uuid_", message);
        this.consumerGroup_ = MessageEventEntery.value("consumerGroup_", message);
        this.eventMessage = message;
        this.eventType = type.ordinal();
        this.ackType = ackType.ordinal();
        this.sendTimes = 0;
        this.retries = retries;
        this.state = KafkaMessageState.READY.ordinal();
        this.nextSendTime = LocalDateTime.now().minusSeconds(3L);
    }

    private static String value(String key, String message) {
        Map map = (Map)JsonHelper.resolve((String)message, Map.class);
        Object value = map.get(key);
        return value == null ? null : String.valueOf(value);
    }

    public void modified(KafkaMessageState state) {
        this.state = state.ordinal();
        ++this.sendTimes;
        this.nextSendTime = LocalDateTime.now().plusMinutes((long)Math.pow(this.sendTimes, 3.0));
    }

    public void retry(String consumerGroup, int count) {
        if (this.parentId == 0L) {
            this.parentId = this.id;
        }
        this.id = null;
        this.setUuid_(UUID.randomUUID().toString());
        this.sendTimes = 0;
        this.nextSendTime = LocalDateTime.now().plusMinutes((long)Math.pow(count + 1, 3.0));
        this.setVersion(0L);
        this.state = KafkaMessageState.READY.ordinal();
        this.consumerGroup_ = consumerGroup;
    }

    public Long getId() {
        return this.id;
    }

    public String getUuid_() {
        return this.uuid_;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getEventMessage() {
        return this.eventMessage;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getAckType() {
        return this.ackType;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getSendTimes() {
        return this.sendTimes;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getState() {
        return this.state;
    }

    public String getConsumerGroup_() {
        return this.consumerGroup_;
    }

    public LocalDateTime getNextSendTime() {
        return this.nextSendTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUuid_(String uuid_) {
        this.uuid_ = uuid_;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public void setAckType(int ackType) {
        this.ackType = ackType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSendTimes(int sendTimes) {
        this.sendTimes = sendTimes;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setConsumerGroup_(String consumerGroup_) {
        this.consumerGroup_ = consumerGroup_;
    }

    public void setNextSendTime(LocalDateTime nextSendTime) {
        this.nextSendTime = nextSendTime;
    }
}

