/*
 * Decompiled with CFR 0.152.
 */
package cn.shenyanchao.ut;

import cn.shenyanchao.builder.ClassTypeBuilder;
import cn.shenyanchao.builder.CompilationUnitBuilder;
import cn.shenyanchao.filter.JavaFileFilter;
import cn.shenyanchao.generator.TestGenerator;
import cn.shenyanchao.utils.JavaParserFactory;
import cn.shenyanchao.utils.MembersFilter;
import cn.shenyanchao.utils.PackageUtils;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="source2test", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class AstGenerator
extends AbstractMojo {
    @Parameter(defaultValue="UTF-8", property="sourceEncode", required=false)
    private String sourceEncode;
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDir", required=false)
    private String sourceDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testDir", required=false)
    private String testDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"############################################################");
        this.getLog().info((CharSequence)this.sourceDir);
        this.getLog().info((CharSequence)this.testDir);
        this.getLog().info((CharSequence)"############################################################");
        File sourceDirectory = new File(this.sourceDir);
        File testDirectory = new File(this.testDir);
        this.makeDirIfNotExist(sourceDirectory);
        this.makeDirIfNotExist(testDirectory);
        Iterator fileItr = FileUtils.iterateFiles((File)sourceDirectory, (IOFileFilter)new JavaFileFilter(), (IOFileFilter)TrueFileFilter.INSTANCE);
        while (fileItr.hasNext()) {
            File javaFile = (File)fileItr.next();
            this.getLog().info((CharSequence)("start process file:" + javaFile.getAbsolutePath()));
            this.convertJavaFile2Test(javaFile);
        }
    }

    private void makeDirIfNotExist(File dir) {
        if (!dir.isDirectory()) {
            this.getLog().error((CharSequence)(dir.getAbsolutePath() + "is not a directory!"));
        }
        if (!dir.exists()) {
            boolean success = false;
            while (!success) {
                success = dir.mkdirs();
            }
        }
    }

    private void convertJavaFile2Test(File javaFile) {
        CompilationUnit compilationUnit = JavaParserFactory.getCompilationUnit(javaFile, this.sourceEncode);
        CompilationUnitBuilder compilationUnitBuilder = new CompilationUnitBuilder();
        compilationUnitBuilder.buildComment("This TestClass is Auto Generated By ut-maven-plugin");
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        String testPackageName = PackageUtils.getTestPackageNameFrom(packageDeclaration);
        compilationUnitBuilder.buildPackage(testPackageName);
        List typeList = compilationUnit.getTypes();
        for (Object type : typeList) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)type;
            String className = typeDeclaration.getName();
            this.getLog().info((CharSequence)("className:" + className));
            ClassTypeBuilder classTypeBuilder = new ClassTypeBuilder(className + "Test");
            List<MethodDeclaration> methodDeclarations = MembersFilter.findMethodsFrom(typeDeclaration);
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                compilationUnitBuilder.buildImports(null);
                String methodName = methodDeclaration.getName();
                this.getLog().info((CharSequence)("methodName:" + methodDeclaration.getName()));
                classTypeBuilder.buildMethod(methodName + "Test", methodDeclaration, new String[0]);
            }
            compilationUnitBuilder.buildClass(classTypeBuilder.build());
        }
        CompilationUnit testCompilationUnit = compilationUnitBuilder.build();
        TestGenerator.writeJavaTest(this.testDir, testCompilationUnit);
    }
}

