/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.provider;

import cn.silwings.dicti18n.loader.DictI18nLoader;
import cn.silwings.dicti18n.provider.DictI18nProvider;
import cn.silwings.dicti18n.sorter.DictLoaderSorter;
import cn.silwings.dicti18n.utils.LangFallbackUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class CompositeDictI18nProvider
implements DictI18nProvider {
    public static final String FALLBACK_LOCALE_KEY = "";
    private final List<DictI18nLoader> loaders;
    private final Map<String, List<String>> fallbackLangChainCache;

    public CompositeDictI18nProvider(DictLoaderSorter sorter) {
        this.loaders = sorter.getOrderedLoaders();
        this.fallbackLangChainCache = new ConcurrentHashMap<String, List<String>>();
        if (this.loaders.isEmpty()) {
            throw new IllegalArgumentException("[DictI18n] Provide at least one DictI18nLoader.");
        }
    }

    @Override
    public Optional<String> getText(String language, String defaultLanguage, String dictName, String code) {
        List<String> langChain = this.getFallbackLangChain(language);
        boolean includeDefaultLang = !langChain.contains(defaultLanguage);
        for (DictI18nLoader loader : this.loaders) {
            Optional<String> dictDesc = this.getTextFromLoader(langChain, dictName, code, loader);
            if (!dictDesc.isPresent() && includeDefaultLang) {
                dictDesc = this.getTextFromLoader(this.getFallbackLangChain(defaultLanguage), dictName, code, loader);
            }
            if (!dictDesc.isPresent() && !FALLBACK_LOCALE_KEY.equals(defaultLanguage)) {
                dictDesc = this.getTextFromLoader(this.getFallbackLangChain(FALLBACK_LOCALE_KEY), dictName, code, loader);
            }
            if (!dictDesc.isPresent()) continue;
            return dictDesc;
        }
        return Optional.empty();
    }

    private Optional<String> getTextFromLoader(List<String> langChain, String dictName, String code, DictI18nLoader loader) {
        for (String lang : langChain) {
            Optional<String> result = loader.get(lang, this.resolveKey(dictName, code)).filter(StringUtils::isNotBlank);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public String resolveKey(String dictName, String code) {
        return dictName + "." + code;
    }

    private List<String> getFallbackLangChain(String language) {
        return this.fallbackLangChainCache.computeIfAbsent(language, LangFallbackUtils::fallbackLangChain);
    }
}

