/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.sorter;

import cn.silwings.dicti18n.config.DictI18nProperties;
import cn.silwings.dicti18n.loader.DictI18nLoader;
import cn.silwings.dicti18n.sorter.DictLoaderSorter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DictLoaderConfigSorter
implements DictLoaderSorter {
    private final DictI18nProperties properties;
    private final List<DictI18nLoader> allLoaders;

    public DictLoaderConfigSorter(DictI18nProperties properties, List<DictI18nLoader> allLoaders) {
        this.properties = properties;
        this.allLoaders = allLoaders;
    }

    @Override
    public List<DictI18nLoader> getOrderedLoaders() {
        List<String> configOrder = this.properties.getLoaderOrder();
        if (null == configOrder || configOrder.isEmpty()) {
            return new ArrayList<DictI18nLoader>(this.allLoaders);
        }
        Map loaderMap = this.allLoaders.stream().collect(Collectors.toMap(DictI18nLoader::loaderName, Function.identity()));
        ArrayList<DictI18nLoader> ordered = new ArrayList<DictI18nLoader>();
        HashSet<String> used = new HashSet<String>();
        for (String name : configOrder) {
            DictI18nLoader loader = (DictI18nLoader)loaderMap.get(name);
            if (null == loader) continue;
            ordered.add(loader);
            used.add(name);
        }
        for (DictI18nLoader loader : this.allLoaders) {
            if (used.contains(loader.loaderName())) continue;
            ordered.add(loader);
        }
        return ordered;
    }
}

