/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class LangFallbackUtils {
    private LangFallbackUtils() {
    }

    public static List<String> fallbackLangChain(String lang) {
        if (StringUtils.isBlank((CharSequence)lang)) {
            return Collections.singletonList("");
        }
        lang = lang.trim().replace('_', '-');
        ArrayList<String> fallbackList = new ArrayList<String>();
        fallbackList.add(lang);
        if (lang.contains("-")) {
            String baseLang = lang.substring(0, lang.indexOf(45));
            fallbackList.add(baseLang);
        }
        return LangFallbackUtils.toLowerCase(fallbackList);
    }

    public static List<String> fallbackLangChain(Locale locale) {
        if (null == locale) {
            return Collections.emptyList();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        ArrayList<String> fallbackList = new ArrayList<String>();
        if (!language.isEmpty() && !country.isEmpty()) {
            fallbackList.add(language + "-" + country);
        }
        if (!language.isEmpty()) {
            fallbackList.add(language);
        }
        return LangFallbackUtils.toLowerCase(fallbackList);
    }

    private static List<String> toLowerCase(List<String> fallbackList) {
        return fallbackList.stream().map(String::toLowerCase).collect(Collectors.toList());
    }
}

