/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.processor;

import cn.silwings.dicti18n.annotation.DictDesc;
import cn.silwings.dicti18n.annotation.DictModel;
import cn.silwings.dicti18n.config.DictI18nProperties;
import cn.silwings.dicti18n.dict.Dict;
import cn.silwings.dicti18n.provider.DictI18nProvider;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictI18nProcessor {
    private static final Logger log = LoggerFactory.getLogger(DictI18nProcessor.class);
    private final DictI18nProvider i18nProvider;
    private final Map<Class<?>, Boolean> processableCache = new ConcurrentHashMap();
    private final DictI18nProperties dictI18nProperties;

    public DictI18nProcessor(DictI18nProvider i18nProvider, DictI18nProperties dictI18nProperties) {
        this.i18nProvider = i18nProvider;
        this.dictI18nProperties = dictI18nProperties;
    }

    public int getMaxRecursionDepth() {
        return this.dictI18nProperties.getMaxNestingDepth();
    }

    public void process(Object body, String language) {
        if (Objects.isNull(body)) {
            return;
        }
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        if (body instanceof Collection) {
            ((Collection)body).forEach(e -> this.processObject(e, language, 0, visited));
        } else if (body instanceof Map) {
            ((Map)body).values().forEach(e -> this.processObject(e, language, 0, visited));
        } else {
            this.processObject(body, language, 0, visited);
        }
    }

    private void processObject(Object target, String language, int depth, Set<Object> visited) {
        if (target == null || this.isJavaBasicType(target.getClass()) || depth > this.getMaxRecursionDepth()) {
            if (depth > this.getMaxRecursionDepth()) {
                log.debug("[DictI18n] When looking up a field, the recursion exceeds the maximum recursion depth");
            }
            return;
        }
        if (!visited.add(target)) {
            return;
        }
        Class<?> clazz = target.getClass();
        for (Field descField : this.getAllFields(clazz)) {
            try {
                this.processField(target, descField, clazz, language, depth + 1, visited);
            }
            catch (Exception e) {
                log.debug("[DictI18n] The processing field failed and the reason for the failure: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = type; null != current && current != Object.class; current = current.getSuperclass()) {
            Collections.addAll(fields, current.getDeclaredFields());
        }
        return fields;
    }

    private void processField(Object target, Field descField, Class<?> clazz, String language, int depth, Set<Object> visited) throws Exception {
        descField.setAccessible(true);
        DictDesc annotation = descField.getAnnotation(DictDesc.class);
        if (null != annotation) {
            this.setDictDescToField(target, descField, annotation, clazz, language);
        } else {
            Object nestedValue = descField.get(target);
            if (null != nestedValue) {
                Class<?> fieldType = nestedValue.getClass();
                if (nestedValue instanceof Collection) {
                    ((Collection)nestedValue).forEach(e -> this.processObject(e, language, depth + 1, visited));
                } else if (nestedValue instanceof Map) {
                    ((Map)nestedValue).values().forEach(e -> this.processObject(e, language, depth + 1, visited));
                } else if (this.shouldProcessType(fieldType, depth + 1)) {
                    this.processObject(nestedValue, language, depth + 1, visited);
                }
            }
        }
    }

    private void setDictDescToField(Object target, Field descField, DictDesc annotation, Class<?> clazz, String language) {
        String dictName = this.getDictName(annotation);
        String baseFieldName = this.getBaseFieldName(annotation, descField);
        if (StringUtils.isNotBlank((CharSequence)baseFieldName)) {
            try {
                Field baseField = this.getFieldRecursively(clazz, baseFieldName);
                baseField.setAccessible(true);
                Object baseFieldValue = baseField.get(target);
                Object dictCode = baseFieldValue instanceof Dict ? ((Dict)baseFieldValue).code() : baseFieldValue;
                if (dictCode instanceof String) {
                    String text = this.i18nProvider.getText(language, this.dictI18nProperties.getDefaultLang(), dictName, (String)dictCode).filter(s -> !s.isEmpty()).orElseGet(() -> this.dictI18nProperties.isReturnKeyIfEmpty() ? dictName + "." + dictCode : "");
                    descField.set(target, text);
                }
            }
            catch (Exception e) {
                log.error("[DictI18n] SetDictDescToField failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String getDictName(DictDesc annotation) {
        Dict[] enums = annotation.value().getEnumConstants();
        if (enums.length > 0) {
            return enums[0].dictName();
        }
        try {
            return annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).dictName();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("[DictI18n] Failed to instantiate Dict enum class '{}' via no-arg constructor. Please check class design.", (Object)annotation.value().getName(), (Object)e);
            return null;
        }
    }

    private Field getFieldRecursively(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        while (null != clazz && clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException("[DictI18n] Field '" + fieldName + "' not found in class hierarchy");
    }

    private boolean isJavaBasicType(Class<?> clazz) {
        return clazz == String.class || clazz == Date.class || clazz.isPrimitive() || clazz.isEnum() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    private String getBaseFieldName(DictDesc annotation, Field descField) {
        if (StringUtils.isNotBlank((CharSequence)annotation.field())) {
            return annotation.field();
        }
        String descFieldName = descField.getName();
        if (descFieldName.endsWith("Desc") && descFieldName.length() > 4) {
            return descFieldName.substring(0, descFieldName.length() - 4);
        }
        return null;
    }

    private boolean shouldProcessType(Class<?> clazz, int depth) {
        if (this.isJavaBasicType(clazz)) {
            return false;
        }
        return this.processableCache.computeIfAbsent(clazz, key -> this.deepScanForDictDesc((Class<?>)key, depth, new HashSet()));
    }

    private boolean deepScanForDictDesc(Class<?> rootClass, int startDepth, Set<Class<?>> visitedClasses) {
        int maxDepth = this.getMaxRecursionDepth();
        ArrayDeque<ScanNode> stack = new ArrayDeque<ScanNode>();
        stack.push(new ScanNode(rootClass, startDepth));
        while (!stack.isEmpty()) {
            ScanNode current = (ScanNode)stack.pop();
            Class<?> clazz = current.clazz;
            int depth = current.depth;
            if (depth > maxDepth) {
                log.debug("[DictI18n] Recursion depth exceeds maximum limit: {}", (Object)maxDepth);
                continue;
            }
            if (visitedClasses.contains(clazz)) continue;
            visitedClasses.add(clazz);
            if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (clazz.isAnnotationPresent(DictModel.class)) {
                return true;
            }
            for (Field field : this.getAllFields(clazz)) {
                if (field.isAnnotationPresent(DictDesc.class)) {
                    return true;
                }
                Class<?> fieldType = field.getType();
                if (this.isJavaBasicType(fieldType) || visitedClasses.contains(fieldType)) continue;
                stack.push(new ScanNode(fieldType, depth + 1));
            }
        }
        return false;
    }

    private static class ScanNode {
        final Class<?> clazz;
        final int depth;

        ScanNode(Class<?> clazz, int depth) {
            this.clazz = clazz;
            this.depth = depth;
        }
    }
}

