/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.file;

import cn.silwings.dicti18n.file.config.FileDictI18nLoaderProperties;
import cn.silwings.dicti18n.loader.ClassPathDictI18nLoader;
import cn.silwings.dicti18n.loader.parser.DictFileParser;
import cn.silwings.dicti18n.loader.parser.DictInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FileDictI18nLoader
implements ClassPathDictI18nLoader {
    private static final Logger log = LoggerFactory.getLogger(FileDictI18nLoader.class);
    private final FileDictI18nLoaderProperties fileDictI18nLoaderProperties;
    private final DictFileParser dictFileParser;
    private final Map<String, Map<String, String>> dictData;

    public FileDictI18nLoader(FileDictI18nLoaderProperties fileDictI18nLoaderProperties, DictFileParser dictFileParser) {
        this.fileDictI18nLoaderProperties = fileDictI18nLoaderProperties;
        this.dictFileParser = dictFileParser;
        this.dictData = new ConcurrentHashMap<String, Map<String, String>>();
    }

    public Logger getLog() {
        return log;
    }

    @PostConstruct
    public void loadAll() {
        Resource[] resources;
        for (Resource resource : resources = this.loadResourcesFromPattern(this.fileDictI18nLoaderProperties.getLocationPatterns())) {
            String lang = this.extractLangFromFilename(resource);
            if (null == lang) continue;
            List dictInfoList = this.dictFileParser.parse(resource);
            Map langDictMap = this.dictData.computeIfAbsent(lang, key -> new ConcurrentHashMap());
            dictInfoList.stream().filter(DictInfo::isValid).forEach(dictInfo -> langDictMap.put(this.fileDictI18nLoaderProperties.processKey(dictInfo.getDictKey()), dictInfo.getDictDesc()));
        }
    }

    public String loaderName() {
        return "file";
    }

    public Optional<String> get(String lang, String dictKey) {
        if (null == lang || lang.isEmpty() || null == dictKey || dictKey.isEmpty()) {
            return Optional.empty();
        }
        if (this.dictData.containsKey(lang)) {
            return Optional.ofNullable(this.dictData.get(lang).get(this.fileDictI18nLoaderProperties.processKey(dictKey)));
        }
        return Optional.empty();
    }
}

