/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.redis.init;

import cn.silwings.dicti18n.loader.parser.DictFileParser;
import cn.silwings.dicti18n.loader.parser.DictInfo;
import cn.silwings.dicti18n.loader.redis.RedisDictI18nLoader;
import cn.silwings.dicti18n.loader.redis.config.RedisDictI18nLoaderProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public class DictI18nRedisDataInitializer {
    private static final String SAVE_SCRIPT = "local mode = ARGV[1]\nfor i = 2, #ARGV, 2 do\n    local key = ARGV[i]\n    local value = ARGV[i + 1]\n    if mode == \"FULL\" then\n        redis.call(\"SET\", key, value)\n    elseif mode == \"INCREMENTAL\" then\n        if redis.call(\"EXISTS\", key) == 0 then\n            redis.call(\"SET\", key, value)\n        end\n    else\n        return redis.error_reply(\"Invalid mode: \" .. mode)\n    end\nend\nreturn \"OK\"";
    private static final Logger log = LoggerFactory.getLogger(DictI18nRedisDataInitializer.class);
    private final RedisDictI18nLoaderProperties redisDictI18nLoaderProperties;
    private final RedisDictI18nLoader redisDictI18nLoader;
    private final DictFileParser dictFileParser;
    private final StringRedisTemplate redisTemplate;

    public DictI18nRedisDataInitializer(RedisDictI18nLoaderProperties redisDictI18nLoaderProperties, RedisDictI18nLoader redisDictI18nLoader, DictFileParser dictFileParser, StringRedisTemplate redisTemplate) {
        this.redisDictI18nLoaderProperties = redisDictI18nLoaderProperties;
        this.redisDictI18nLoader = redisDictI18nLoader;
        this.dictFileParser = dictFileParser;
        this.redisTemplate = redisTemplate;
    }

    public void preload() {
        Resource[] resources;
        for (Resource resource : resources = this.redisDictI18nLoader.loadResourcesFromPattern(this.redisDictI18nLoaderProperties.getLocationPatterns())) {
            String result;
            List<DictInfo> dictInfoList;
            String lang = this.redisDictI18nLoader.extractLangFromFilename(resource);
            if (null == lang || (dictInfoList = this.dictFileParser.parse(resource).stream().filter(DictInfo::isValid).collect(Collectors.toList())).isEmpty()) continue;
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.redisDictI18nLoaderProperties.getPreload().getPreloadMode().name());
            dictInfoList.forEach(dictInfo -> {
                String dictKey = this.processKey(lang, (DictInfo)dictInfo);
                args.add(dictKey);
                args.add(dictInfo.getDictDesc());
            });
            RedisScript redisScript = RedisScript.of((String)SAVE_SCRIPT, String.class);
            try {
                result = (String)this.redisTemplate.execute(redisScript, Collections.emptyList(), args.toArray());
            }
            catch (Exception e) {
                if (this.redisDictI18nLoaderProperties.getPreload().isFailFast()) {
                    throw new RedisSystemException("[DictI18n] Failed to execute Redis script due to connection error.", (Throwable)e);
                }
                log.warn("[DictI18n] Redis connection failed: {}", (Object)e.getMessage(), (Object)e);
                return;
            }
            if ("OK".equals(result)) {
                log.info("[DictI18n] Preloaded {} entries for language: {}", (Object)dictInfoList.size(), (Object)(lang.isEmpty() ? "default" : lang));
                continue;
            }
            String errorMsg = "[DictInfo] Redis script execution failed. PreloadMode: " + this.redisDictI18nLoaderProperties.getPreload().getPreloadMode().name() + ", Result: " + result + ".";
            if (this.redisDictI18nLoaderProperties.getPreload().isFailFast()) {
                throw new RedisSystemException(errorMsg, (Throwable)new RuntimeException("[DictI18n] Redis script execution failed."));
            }
            log.warn(errorMsg);
        }
    }

    private String processKey(String lang, DictInfo dictInfo) {
        return this.redisDictI18nLoader.processKey(lang, dictInfo.getDictKey());
    }
}

