/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.redis;

import cn.silwings.dicti18n.loader.ClassPathDictI18nLoader;
import cn.silwings.dicti18n.loader.enums.ErrorHandlingStrategy;
import cn.silwings.dicti18n.loader.redis.config.RedisDictI18nLoaderProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisDictI18nLoader
implements ClassPathDictI18nLoader {
    private static final Logger log = LoggerFactory.getLogger(RedisDictI18nLoader.class);
    private final RedisDictI18nLoaderProperties redisDictI18nLoaderProperties;
    private final StringRedisTemplate redisTemplate;

    public RedisDictI18nLoader(RedisDictI18nLoaderProperties redisDictI18nLoaderProperties, StringRedisTemplate redisTemplate) {
        this.redisDictI18nLoaderProperties = redisDictI18nLoaderProperties;
        this.redisTemplate = redisTemplate;
    }

    public Logger getLog() {
        return log;
    }

    public String processKey(String lang, String dictKey) {
        return this.redisDictI18nLoaderProperties.getKeyPrefix() + ":" + lang + ":" + this.redisDictI18nLoaderProperties.processKey(dictKey);
    }

    public String loaderName() {
        return "redis";
    }

    public Optional<String> get(String lang, String dictKey) {
        String redisKey = this.processKey(lang, dictKey);
        try {
            return Optional.ofNullable((String)this.redisTemplate.opsForValue().get((Object)redisKey));
        }
        catch (Exception e) {
            if (ErrorHandlingStrategy.IGNORE.equals((Object)this.redisDictI18nLoaderProperties.getErrorHandlingStrategy())) {
                log.debug("[DictI18n] Redis query failure: {}", (Object)e.getMessage(), (Object)e);
                return Optional.empty();
            }
            throw e;
        }
    }
}

