/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.sql;

import cn.silwings.dicti18n.loader.ClassPathDictI18nLoader;
import cn.silwings.dicti18n.loader.cache.DictDescGetter;
import cn.silwings.dicti18n.loader.cache.DictI18nLoaderCacheProvider;
import cn.silwings.dicti18n.loader.enums.ErrorHandlingStrategy;
import cn.silwings.dicti18n.loader.sql.config.SqlDictI18nLoaderProperties;
import cn.silwings.dicti18n.loader.sql.db.SQLTemplate;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;

public class SqlDictI18nLoader
implements ClassPathDictI18nLoader {
    private static final Logger log = LoggerFactory.getLogger(SqlDictI18nLoader.class);
    private final SQLTemplate sqlTemplate;
    private final DictI18nLoaderCacheProvider dictI18nLoaderCacheProvider;
    private final SqlDictI18nLoaderProperties sqlDictI18nLoaderProperties;

    public SqlDictI18nLoader(SQLTemplate sqlTemplate, DictI18nLoaderCacheProvider dictI18nLoaderCacheProvider, SqlDictI18nLoaderProperties sqlDictI18nLoaderProperties) {
        this.sqlTemplate = sqlTemplate;
        this.dictI18nLoaderCacheProvider = dictI18nLoaderCacheProvider;
        this.sqlDictI18nLoaderProperties = sqlDictI18nLoaderProperties;
    }

    public Logger getLog() {
        return log;
    }

    public String loaderName() {
        return "sql";
    }

    public Optional<String> get(String lang, String dictKey) {
        return this.dictI18nLoaderCacheProvider.getDesc(lang, dictKey, this.getDatabaseQuery());
    }

    public DictDescGetter getDatabaseQuery() {
        return (lang, dictKey) -> {
            try {
                String sql = "SELECT description FROM dict_i18n WHERE dict_key = ? AND lang = ? AND enabled = 1 LIMIT 1";
                String description = this.sqlTemplate.queryForObject("SELECT description FROM dict_i18n WHERE dict_key = ? AND lang = ? AND enabled = 1 LIMIT 1", String.class, Arrays.asList(dictKey, lang));
                return Optional.ofNullable(description);
            }
            catch (EmptyResultDataAccessException e) {
                return Optional.empty();
            }
            catch (Exception e) {
                if (ErrorHandlingStrategy.IGNORE.equals((Object)this.sqlDictI18nLoaderProperties.getErrorHandlingStrategy())) {
                    log.debug("[DictI18n] SQL query error: {}", (Object)e.getMessage(), (Object)e);
                    return Optional.empty();
                }
                throw e;
            }
        };
    }
}

