/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.sql.init.data;

import cn.silwings.dicti18n.loader.parser.DictFileParser;
import cn.silwings.dicti18n.loader.parser.DictInfo;
import cn.silwings.dicti18n.loader.sql.SqlDictI18nLoader;
import cn.silwings.dicti18n.loader.sql.config.SqlDictI18nLoaderProperties;
import cn.silwings.dicti18n.loader.sql.init.data.DictI18nSqlDataInitializer;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;

public class DictI18nSqlDataInitRunner
implements ApplicationRunner,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DictI18nSqlDataInitRunner.class);
    public static final int ORDER = 2147483548;
    private final SqlDictI18nLoader sqlDictI18nLoader;
    private final SqlDictI18nLoaderProperties sqlDictI18nLoaderProperties;
    private final DictFileParser dictFileParser;
    private final DictI18nSqlDataInitializer dictI18NSqlDataInitializer;

    public DictI18nSqlDataInitRunner(SqlDictI18nLoader sqlDictI18nLoader, SqlDictI18nLoaderProperties sqlDictI18nLoaderProperties, DictFileParser dictFileParser, DictI18nSqlDataInitializer dictI18NSqlDataInitializer) {
        this.sqlDictI18nLoader = sqlDictI18nLoader;
        this.sqlDictI18nLoaderProperties = sqlDictI18nLoaderProperties;
        this.dictFileParser = dictFileParser;
        this.dictI18NSqlDataInitializer = dictI18NSqlDataInitializer;
    }

    public int getOrder() {
        return 2147483548;
    }

    public void run(ApplicationArguments args) {
        log.info("[DictI18n] Starting to preload data into SQL database.");
        Resource[] resources = this.sqlDictI18nLoader.loadResourcesFromPattern(this.sqlDictI18nLoaderProperties.getLocationPatterns());
        HashMap<String, List<DictInfo>> langDictMap = new HashMap<String, List<DictInfo>>();
        for (Resource resource : resources) {
            List dictInfoList;
            String lang = this.sqlDictI18nLoader.extractLangFromFilename(resource);
            if (null == lang || (dictInfoList = this.dictFileParser.parse(resource).stream().filter(DictInfo::isValid).collect(Collectors.toList())).isEmpty()) continue;
            langDictMap.put(lang, dictInfoList);
        }
        try {
            this.dictI18NSqlDataInitializer.initialize(langDictMap, this.sqlDictI18nLoaderProperties.getPreload().getPreloadMode());
            log.info("[DictI18n] Completed preloaded data into SQL database.");
        }
        catch (Exception e) {
            if (this.sqlDictI18nLoaderProperties.getPreload().isFailFast()) {
                log.error("[DictI18n] Failed to preload data into SQL database.", (Throwable)e);
                throw e;
            }
            log.warn("[DictI18n] Failed to preload data into SQL database, continuing without preloading.", (Throwable)e);
        }
    }
}

