/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.sql.db;

import cn.silwings.dicti18n.loader.sql.db.SQLTemplate;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcSQLTemplate
implements SQLTemplate {
    private final JdbcTemplate jdbcTemplate;

    public JdbcSQLTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String queryForObject(String sql, Class<String> requiredType, List<?> args) {
        return (String)this.jdbcTemplate.queryForObject(sql, requiredType, args.toArray());
    }

    @Override
    public <T> List<T> query(String selectSql, ResultMapper<T> rowMapper, List<?> args) {
        return this.jdbcTemplate.query(selectSql, (res, index) -> rowMapper.mapRow(res), args.toArray());
    }

    @Override
    public void update(String updateSql, List<?> args) {
        this.jdbcTemplate.update(updateSql, args.toArray());
    }

    @Override
    public <T> void batchUpdate(String updateSql, final List<T> dataList, final SQLTemplate.BatchPreparedStatementSetter<T> batchPreparedStatementSetter) {
        this.jdbcTemplate.batchUpdate(updateSql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                batchPreparedStatementSetter.setValues(ps, i, dataList.get(i));
            }

            public int getBatchSize() {
                return dataList.size();
            }
        });
    }

    @Override
    public void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public String getDatabaseProductName() {
        try {
            DataSource dataSource = this.jdbcTemplate.getDataSource();
            if (null == dataSource) {
                throw new IllegalStateException("[DictI18n] JdbcTemplate has no DataSource");
            }
            DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
            return metaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new RuntimeException("[DictI18n] Failed to get database product name", e);
        }
    }

    public static interface ResultMapper<T> {
        public T mapRow(ResultSet var1) throws SQLException;
    }
}

