/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.sql.init.data;

import cn.silwings.dicti18n.loader.enums.PreLoadMode;
import cn.silwings.dicti18n.loader.parser.DictInfo;
import cn.silwings.dicti18n.loader.sql.db.SQLTemplate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class DictI18nSqlDataInitializer {
    private final SQLTemplate sqlTemplate;

    public DictI18nSqlDataInitializer(SQLTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    @Transactional(rollbackFor={Exception.class})
    public void initialize(Map<String, List<DictInfo>> langDictMap, PreLoadMode preloadMode) {
        langDictMap.forEach((language, dictList) -> this.initializeByLanguage((String)language, (List<DictInfo>)dictList, preloadMode));
    }

    private void initializeByLanguage(String language, List<DictInfo> dictList, PreLoadMode preloadMode) {
        if (null == language || null == dictList || dictList.isEmpty()) {
            return;
        }
        switch (preloadMode) {
            case FULL: {
                this.executeFullUpdate(language, dictList);
                break;
            }
            case INCREMENTAL: {
                this.executeIncrementalUpdate(language, dictList);
                break;
            }
            default: {
                throw new IllegalArgumentException("[DictI18n] Unsupported preload mode: " + preloadMode);
            }
        }
    }

    private void executeIncrementalUpdate(String language, List<DictInfo> dictList) {
        List params = dictList.stream().map(DictInfo::getDictKey).distinct().collect(Collectors.toList());
        String selectSql = "SELECT dict_key FROM dict_i18n WHERE lang = ? AND dict_key IN (" + String.join((CharSequence)",", Collections.nCopies(params.size(), "?")) + ")";
        params.add(0, language);
        List<String> dictKeyList = this.sqlTemplate.query(selectSql, rs -> rs.getString("dict_key"), params);
        HashSet<String> existingKeys = new HashSet<String>(dictKeyList);
        List<DictInfo> newItems = dictList.stream().filter(dictInfo -> !existingKeys.contains(dictInfo.getDictKey())).collect(Collectors.toList());
        if (!newItems.isEmpty()) {
            this.batchInsert(language, newItems);
        }
    }

    private void executeFullUpdate(String language, List<DictInfo> dictList) {
        List params = dictList.stream().map(DictInfo::getDictKey).distinct().collect(Collectors.toList());
        if (!params.isEmpty()) {
            String deleteSql = "DELETE FROM dict_i18n WHERE lang = ? AND dict_key IN (" + String.join((CharSequence)",", Collections.nCopies(params.size(), "?")) + ")";
            params.add(0, language);
            this.sqlTemplate.update(deleteSql, params);
        }
        this.batchInsert(language, dictList);
    }

    private void batchInsert(String language, List<DictInfo> dictList) {
        String insertSql = "INSERT INTO dict_i18n (dict_key, lang, description, enabled) VALUES (?, ?, ?, ?)";
        this.sqlTemplate.batchUpdate("INSERT INTO dict_i18n (dict_key, lang, description, enabled) VALUES (?, ?, ?, ?)", dictList, (ps, index, dict) -> {
            ps.setString(1, dict.getDictKey());
            ps.setString(2, language);
            ps.setString(3, dict.getDictDesc());
            ps.setInt(4, 1);
        });
    }
}

