/*
 * Decompiled with CFR 0.152.
 */
package cn.silwings.dicti18n.loader.sql.init.schema;

import cn.silwings.dicti18n.loader.sql.db.SQLTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class DictI18nSchemaInitializer {
    private static final Logger log = LoggerFactory.getLogger(DictI18nSchemaInitializer.class);
    private final SQLTemplate sqlTemplate;

    public DictI18nSchemaInitializer(SQLTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public void initialize() {
        String[] sqls;
        String databaseProductName = this.sqlTemplate.getDatabaseProductName();
        if (null == databaseProductName) {
            throw new IllegalStateException("[DictI18n] Failed to determine database product name");
        }
        log.info("[DictI18n] Starting schema initialization for database: {}", (Object)databaseProductName);
        for (String sql : sqls = this.getInitSqlByDatabase(databaseProductName)) {
            try {
                log.debug("[DictI18n] Executing SQL: {}", (Object)sql);
                this.sqlTemplate.execute(sql);
            }
            catch (DataAccessException e) {
                String message = e.getMessage();
                if (null == message || !message.contains("Duplicate") && !message.contains("already exists")) {
                    log.error("[DictI18n] Failed to execute SQL: {}", (Object)sql, (Object)e);
                    throw e;
                }
                log.debug("[DictI18n] Ignored duplicate-related error for SQL: {}", (Object)sql);
            }
        }
        log.info("[DictI18n] Completed schema initialization for database.");
    }

    private String[] getInitSqlByDatabase(String databaseProductName) {
        switch (databaseProductName.toLowerCase()) {
            case "mysql": {
                return new String[]{"CREATE TABLE IF NOT EXISTS dict_i18n (id BIGINT AUTO_INCREMENT PRIMARY KEY,dict_key VARCHAR(512) NOT NULL,lang VARCHAR(10) NOT NULL,description VARCHAR(1024) NOT NULL,enabled TINYINT NOT NULL DEFAULT 1 COMMENT 'Enable or not: 1-Enable, 0-Disable',UNIQUE KEY uidx_dicti18n_dictkey_lang (dict_key, lang)) ENGINE=InnoDB;", "CREATE INDEX idx_dicti18n_dictkey ON dict_i18n (dict_key);", "CREATE INDEX idx_dicti18n_lang ON dict_i18n (lang);"};
            }
            case "postgresql": {
                return new String[]{"CREATE TABLE IF NOT EXISTS dict_i18n (id BIGSERIAL PRIMARY KEY,dict_key VARCHAR(512) NOT NULL,lang VARCHAR(10) NOT NULL,description VARCHAR(1024) NOT NULL,enabled SMALLINT NOT NULL DEFAULT 1,UNIQUE (dict_key, lang));", "CREATE INDEX IF NOT EXISTS idx_dicti18n_dictkey ON dict_i18n (dict_key);", "CREATE INDEX IF NOT EXISTS idx_dicti18n_lang ON dict_i18n (lang);"};
            }
            case "sqlite": {
                return new String[]{"CREATE TABLE IF NOT EXISTS dict_i18n (id INTEGER PRIMARY KEY AUTOINCREMENT,dict_key TEXT NOT NULL,lang TEXT NOT NULL,description TEXT NOT NULL,enabled INTEGER NOT NULL DEFAULT 1 CHECK (enabled IN (0, 1)),UNIQUE(dict_key, lang));", "CREATE INDEX IF NOT EXISTS idx_dicti18n_dictkey ON dict_i18n (dict_key);", "CREATE INDEX IF NOT EXISTS idx_dicti18n_lang ON dict_i18n (lang);"};
            }
        }
        throw new UnsupportedOperationException("[DictI18n] Unsupported database: " + databaseProductName);
    }
}

