package cn.sinozg.applet.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* 自定义注解防止表单重复提交
 * 以10秒为单位 最小粒度10秒1次
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:28
**/
@Inherited
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RepeatSubmit {

    /** 可以重复多少次 默认为1次 */
    int times() default 1;

    /** 是否忽略参数  */
    boolean withParams() default true ;
}
