package cn.sinozg.applet.common.customizer;

import cn.sinozg.applet.common.annotation.JsonField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.SqlSessionFactoryBeanCustomizer;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

import static org.springframework.util.StringUtils.tokenizeToStringArray;

/**
 * 自动转意数据库 json 字段
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-03-07 13:50
 */
@Component
public class JsonFieldCustomizer implements SqlSessionFactoryBeanCustomizer {
    @javax.annotation.Resource
    private MybatisPlusProperties properties;
    private static final Logger log = LoggerFactory.getLogger(JsonFieldCustomizer.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();

    @Override
    public void customize(MybatisSqlSessionFactoryBean factoryBean)  {
        try {
            Set<Class<?>> classes = scanClasses(properties.getTypeAliasesPackage());
            Set<Class<?>> mapType = new HashSet<>();
            TypeHandlerRegistry registry = factoryBean.getConfiguration().getTypeHandlerRegistry();
            classes.forEach(clazz -> {
                Field[] fields = clazz.getDeclaredFields();
                for (Field field : fields) {
                    if (!Modifier.isStatic(field.getModifiers()) && field.getAnnotation(JsonField.class) != null) {
                        if (mapType.contains(field.getType())) {
                            continue;
                        }
                        mapType.add(field.getType());
                        registry.register(field.getType(), JacksonTypeHandler.class);
                    }
                }
            });
        } catch (Exception e) {
            log.error("JsonFieldCustomizer error", e);
        }

    }

    private Set<Class<?>> scanClasses(String packagePatterns) throws Exception {
        Class<?> assignableType = null;
        Set<Class<?>> classes = new HashSet<>();
        String[] packagePatternArray = tokenizeToStringArray(packagePatterns, ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS);
        boolean isEntity;
        for (String packagePattern : packagePatternArray) {
            Resource[] resources = RESOURCE_PATTERN_RESOLVER.getResources(ResourcePatternResolver.CLASSPATH_ALL_URL_PREFIX
                    + ClassUtils.convertClassNameToResourcePath(packagePattern) + "/**/*.class");
            for (Resource resource : resources) {
                try {
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class<?> clazz = Resources.classForName(classMetadata.getClassName());
                    isEntity = (assignableType == null || assignableType.isAssignableFrom(clazz)) && clazz.getAnnotation(TableName.class) != null;
                    if (isEntity) {
                        classes.add(clazz);
                    }
                } catch (Throwable e) {
                    log.warn("Cannot load the '{}'. Cause by {}", resource, e.toString());
                }
            }
        }
        return classes;
    }
}
