/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.aspectj;

import cn.sinozg.applet.common.annotation.RateLimiter;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.PojoWebUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Order(value=2)
@Aspect
@Component
public class RateLimiterAspect {
    @Resource
    private RedissonClient redissonClient;
    private final Logger log = LoggerFactory.getLogger(RateLimiterAspect.class);

    @Around(value="@annotation(rl)")
    public Object around(ProceedingJoinPoint jp, RateLimiter rl) throws Throwable {
        String ak;
        String id = rl.id();
        if (StringUtils.isBlank((CharSequence)id)) {
            id = PojoWebUtil.methodKey((JoinPoint)jp, (String)":");
        }
        if (StringUtils.isNotBlank((CharSequence)(ak = rl.key()))) {
            ak = PojoWebUtil.getElValue((JoinPoint)jp, (String)ak);
        }
        if (StringUtils.isBlank((CharSequence)ak)) {
            ak = OsUtil.getHostIp();
        }
        String key = String.format("jby:biz:rate_limiter:%s:%s", id, ak);
        RRateLimiter limiter = this.redissonClient.getRateLimiter(key);
        limiter.trySetRate(RateType.OVERALL, (long)rl.limit(), 1L, this.unit(rl));
        limiter.expire(rl.unit().duration(2));
        if (!limiter.tryAcquire()) {
            this.log.error("\u9650\u6d41\uff0cID \u4e3a{}, key \u4e3a {}", (Object)id, (Object)ak);
            WebUtil.response().setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            throw new CavException("Too Many Requests");
        }
        return jp.proceed();
    }

    private RateIntervalUnit unit(RateLimiter anon) {
        switch (anon.unit()) {
            case DAYS: {
                return RateIntervalUnit.DAYS;
            }
            case HOURS: {
                return RateIntervalUnit.HOURS;
            }
            case SECONDS: {
                return RateIntervalUnit.SECONDS;
            }
        }
        return RateIntervalUnit.MINUTES;
    }
}

