/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.aspectj;

import cn.sinozg.applet.common.annotation.RedissonLock;
import cn.sinozg.applet.common.enums.LockGranularityType;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.PojoWebUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Order(value=1)
@Aspect
@Component
public class RedissonLockAspect {
    @Resource
    private RedissonClient redissonClient;
    private final Logger log = LoggerFactory.getLogger(RedissonLockAspect.class);

    @Pointcut(value="@annotation(cn.sinozg.applet.common.annotation.RedissonLock)")
    public void lockPointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="lockPointCut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        Object obj = null;
        RedissonLock annotation = (RedissonLock)PojoWebUtil.getAnnotation((JoinPoint)jp, RedissonLock.class);
        String className = jp.getTarget().getClass().getName();
        Object name = RegExUtils.replacePattern((String)className, (String)"\\.", (String)"");
        name = (String)name + "_" + jp.getSignature().getName();
        String key = annotation.key();
        if (StringUtils.isBlank((CharSequence)key)) {
            key = "@";
        } else {
            String regex = "^#.*.$";
            if (key.matches(regex)) {
                Method method = ((MethodSignature)jp.getSignature()).getMethod();
                key = this.parseKey(key, method, jp.getArgs());
            }
        }
        boolean execute = this.scheduled(annotation, (String)name);
        if (execute) {
            String redisKey = String.format("jby:biz:redisson_key:%s:%s", name, key);
            RLock lock = null;
            try {
                lock = this.redissonClient.getLock(redisKey);
                boolean hasLock = false;
                if (lock != null) {
                    hasLock = lock.tryLock((long)annotation.waitTime(), (long)annotation.leaseTime(), TimeUnit.SECONDS);
                }
                String ip = OsUtil.getHostIp();
                if (hasLock) {
                    this.log.info("{}\u83b7\u53d6\u5230\u9501\uff0c{}\uff0c\u6267\u884c\u540e\u7eed\u4efb\u52a1", (Object)ip, (Object)redisKey);
                    obj = jp.proceed();
                } else {
                    this.log.error("{}\u6ca1\u6709\u83b7\u53d6\u5230\u9501\uff0c{}", (Object)ip, (Object)redisKey);
                }
            }
            finally {
                if (lock != null && lock.isLocked() && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        return obj;
    }

    private boolean scheduled(RedissonLock lock, String name) {
        if (!lock.scheduled()) {
            return true;
        }
        LockGranularityType type = lock.granularity();
        String time = type == LockGranularityType.DAY ? DateUtil.formatDate((LocalDate)LocalDate.now(), (String)type.getPattern()) : DateUtil.formatDateTime((LocalDateTime)LocalDateTime.now(), (String)type.getPattern());
        String flagKey = String.format("jby:biz:redisson_flag:%s:%s", name, time);
        String flag = (String)RedisUtil.getCacheObject((String)flagKey);
        boolean getLock = StringUtils.isBlank((CharSequence)flag);
        if (getLock) {
            RedisUtil.setCacheObject((String)flagKey, (Object)"true", (Duration)Duration.ofDays(1L));
        }
        return getLock;
    }

    private String parseKey(String key, Method method, Object[] args) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        StandardReflectionParameterNameDiscoverer u = new StandardReflectionParameterNameDiscoverer();
        Object[] params = u.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            for (int i = 0; i < params.length; ++i) {
                context.setVariable((String)params[i], args[i]);
            }
        }
        return (String)parser.parseExpression(key).getValue((EvaluationContext)context, String.class);
    }
}

